/*
 * Decompiled with CFR 0.152.
 */
package alexiil.mods.load.json;

import alexiil.mods.load.json.Area;
import alexiil.mods.load.json.EPosition;
import alexiil.mods.load.json.EType;
import java.awt.Color;

public class ImageRender {
    public String resourceLocation;
    public EPosition positionType;
    public EType type;
    public Area texture;
    public Area position;
    public String colour;
    public String text;
    public String comment;

    public ImageRender(String resourceLocation, EPosition positionType, EType type, Area texture, Area position, String colour, String text, String comment) {
        this.resourceLocation = resourceLocation;
        this.positionType = positionType;
        this.type = type;
        this.texture = texture;
        this.position = position;
        this.colour = colour;
        this.text = text;
        this.comment = comment;
    }

    public ImageRender(String resourceLocation, EPosition positionType, EType type, Area texture, Area position) {
        this(resourceLocation, positionType, type, texture, position, null, null, "None");
    }

    public int transformX(int screenWidth) {
        if (this.position == null || this.positionType == null) {
            return 0;
        }
        int trueX = this.position.width;
        if (trueX == 0) {
            trueX = screenWidth;
        }
        return this.positionType.transformX(this.position.x, screenWidth - trueX);
    }

    public int transformY(int screenHeight) {
        if (this.position == null || this.positionType == null) {
            return 0;
        }
        return this.positionType.transformY(this.position.y, screenHeight - this.position.height);
    }

    public int getColour() {
        if (this.colour == null) {
            return 0xFFFFFF;
        }
        try {
            return Integer.parseInt(this.colour, 16);
        }
        catch (NumberFormatException nfe) {
            return 0xFFFFFF;
        }
    }

    public void setColour(Color color) {
        String blue;
        String green;
        String red = Integer.toHexString(color.getRed());
        if (red.length() == 1) {
            red = "0" + red;
        }
        if ((green = Integer.toHexString(color.getGreen())).length() == 1) {
            green = "0" + green;
        }
        if ((blue = Integer.toHexString(color.getBlue())).length() == 1) {
            blue = "0" + blue;
        }
        this.colour = red + green + blue;
    }

    private float getColourPart(int bitStart) {
        return (float)(this.getColour() >> bitStart & 0xFF) / 255.0f;
    }

    public float getRed() {
        return this.getColourPart(16);
    }

    public float getGreen() {
        return this.getColourPart(8);
    }

    public float getBlue() {
        return this.getColourPart(0);
    }
}

