/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net;

import com.google.common.io.ByteArrayDataInput;
import gregtech.GTMod;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class GTPacketTileEntity
extends GTPacket {
    private int mX;
    private int mZ;
    private int mC0;
    private int mC1;
    private int mC2;
    private int mC3;
    private int mC4;
    private int mC5;
    private short mY;
    private short mID;
    private byte mCommon;
    private byte mUpdate;
    private byte mRedstone;
    private byte mColor;

    public GTPacketTileEntity() {
    }

    public GTPacketTileEntity(int aX, short aY, int aZ, short aID, int aC0, int aC1, int aC2, int aC3, int aC4, int aC5, byte aCommon, byte aUpdate, byte aRedstone, byte aColor) {
        this.mX = aX;
        this.mY = aY;
        this.mZ = aZ;
        this.mC0 = aC0;
        this.mC1 = aC1;
        this.mC2 = aC2;
        this.mC3 = aC3;
        this.mC4 = aC4;
        this.mC5 = aC5;
        this.mID = aID;
        this.mCommon = aCommon;
        this.mUpdate = aUpdate;
        this.mRedstone = aRedstone;
        this.mColor = aColor;
    }

    @Override
    public void encode(ByteBuf aOut) {
        aOut.writeInt(this.mX);
        aOut.writeShort((int)this.mY);
        aOut.writeInt(this.mZ);
        aOut.writeShort((int)this.mID);
        aOut.writeInt(this.mC0);
        aOut.writeInt(this.mC1);
        aOut.writeInt(this.mC2);
        aOut.writeInt(this.mC3);
        aOut.writeInt(this.mC4);
        aOut.writeInt(this.mC5);
        aOut.writeByte((int)this.mCommon);
        aOut.writeByte((int)this.mUpdate);
        aOut.writeByte((int)this.mRedstone);
        aOut.writeByte((int)this.mColor);
    }

    @Override
    public GTPacket decode(ByteArrayDataInput aData) {
        return new GTPacketTileEntity(aData.readInt(), aData.readShort(), aData.readInt(), aData.readShort(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readInt(), aData.readByte(), aData.readByte(), aData.readByte(), aData.readByte());
    }

    @Override
    public void process(IBlockAccess aWorld) {
        if (aWorld == null) {
            return;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(this.mX, (int)this.mY, this.mZ);
        try {
            if (tTileEntity instanceof BaseMetaTileEntity) {
                BaseMetaTileEntity tile = (BaseMetaTileEntity)tTileEntity;
                tile.receiveMetaTileEntityData(this.mID, this.mC0, this.mC1, this.mC2, this.mC3, this.mC4, this.mC5, this.mCommon, this.mUpdate, this.mRedstone, this.mColor);
            } else if (tTileEntity instanceof BaseMetaPipeEntity) {
                BaseMetaPipeEntity pipe = (BaseMetaPipeEntity)tTileEntity;
                pipe.receiveMetaTileEntityData(this.mID, this.mC0, this.mC1, this.mC2, this.mC3, this.mC4, this.mC5, this.mCommon, this.mUpdate, this.mRedstone, this.mColor);
            }
        }
        catch (Exception e) {
            GTMod.GT_FML_LOGGER.error("Exception setting tile entity data for tile entity {} at ({}, {}, {})", new Object[]{tTileEntity, this.mX, this.mY, this.mZ});
        }
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.TILE_ENTITY.id;
    }
}

