/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import gregtech.api.covers.CoverContext;
import gregtech.api.gui.modularui.CoverUIBuildContext;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverIOBase;
import gregtech.common.covers.gui.CoverGui;
import gregtech.common.covers.gui.CoverIOBaseGui;
import gregtech.common.gui.mui1.cover.ConveyorUIFactory;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import org.jetbrains.annotations.NotNull;

public class CoverConveyor
extends CoverIOBase {
    public final int mTickRate;
    private final int mMaxStacks;

    public CoverConveyor(CoverContext context, int aTickRate, int maxStacks, ITexture coverTexture) {
        super(context, coverTexture);
        this.mTickRate = aTickRate;
        this.mMaxStacks = maxStacks;
    }

    @Override
    public boolean isRedstoneSensitive(long aTimer) {
        return false;
    }

    @Override
    protected void doTransfer(ICoverable coverable) {
        TileEntity tTileEntity = coverable.getTileEntityAtSide(this.coverSide);
        ICoverable fromEntity = this.coverData % 2 == 0 ? coverable : tTileEntity;
        ICoverable toEntity = this.coverData % 2 != 0 ? coverable : tTileEntity;
        ForgeDirection fromSide = this.coverData % 2 != 0 ? this.coverSide.getOpposite() : this.coverSide;
        ForgeDirection toSide = this.coverData % 2 == 0 ? this.coverSide.getOpposite() : this.coverSide;
        GTUtility.moveMultipleItemStacks(fromEntity, toEntity, fromSide, toSide, null, false, (byte)64, (byte)1, (byte)64, (byte)1, this.mMaxStacks);
    }

    @Override
    public boolean letsRedstoneGoIn() {
        return true;
    }

    @Override
    public boolean letsRedstoneGoOut() {
        return true;
    }

    @Override
    public boolean letsEnergyIn() {
        return true;
    }

    @Override
    public boolean letsEnergyOut() {
        return true;
    }

    @Override
    public boolean letsFluidIn(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsFluidOut(Fluid aFluid) {
        return true;
    }

    @Override
    public boolean letsItemsIn(int aSlot) {
        return this.coverData >= 6 || this.coverData % 2 != 0;
    }

    @Override
    public boolean letsItemsOut(int aSlot) {
        return this.coverData >= 6 || this.coverData % 2 == 0;
    }

    @Override
    public boolean alwaysLookConnected() {
        return true;
    }

    @Override
    public int getMinimumTickRate() {
        return this.mTickRate;
    }

    @Override
    @NotNull
    protected CoverGui<?> getCoverGui() {
        return new CoverIOBaseGui(this, "cover.conveyor");
    }

    @Override
    public boolean hasCoverGUI() {
        return true;
    }

    @Override
    public ModularWindow createWindow(CoverUIBuildContext buildContext) {
        return new ConveyorUIFactory(buildContext).createWindow();
    }
}

