/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.powergoggles;

import appeng.api.util.DimensionalCoord;
import gregtech.api.enums.GTValues;
import gregtech.api.net.GTPacketOverwritePowerGogglesMeasurements;
import gregtech.api.net.GTPacketUpdatePowerGoggles;
import gregtech.common.misc.WirelessNetworkManager;
import gregtech.common.powergoggles.PowerGogglesConstants;
import gregtech.common.powergoggles.PowerGogglesMeasurement;
import gregtech.common.powergoggles.PowerGogglesUtil;
import gregtech.common.powergoggles.PowerGogglesWorldSavedData;
import java.math.BigInteger;
import java.util.LinkedList;
import java.util.Objects;
import java.util.UUID;
import kekztech.common.tileentities.MTELapotronicSuperCapacitor;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class PowerGogglesClient {
    private DimensionalCoord lscLink;
    private LinkedList<PowerGogglesMeasurement> measurements = new LinkedList();

    public PowerGogglesClient() {
    }

    public PowerGogglesClient(DimensionalCoord lscLink) {
        this.lscLink = lscLink;
    }

    public void updateLscLink(ItemStack itemstack, EntityPlayerMP player) {
        NBTTagCompound tag = itemstack.func_77978_p();
        DimensionalCoord newLink = null;
        if (tag != null && !tag.func_82582_d()) {
            newLink = new DimensionalCoord(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74762_e("dim"));
        }
        if (!Objects.equals(this.lscLink, newLink)) {
            this.setLscLink(newLink);
            this.measurements.clear();
            this.overwriteMeasurements(player);
            PowerGogglesWorldSavedData.INSTANCE.func_76185_a();
        }
    }

    public void setLscLink(DimensionalCoord lscLink) {
        this.lscLink = lscLink;
    }

    public void updatePlayer(EntityPlayerMP playerMP) {
        if (this.measurements.isEmpty()) {
            return;
        }
        PowerGogglesMeasurement lastMeasurement = this.measurements.getLast();
        if (lastMeasurement.isWireless()) {
            GTValues.NW.sendToPlayer(new GTPacketUpdatePowerGoggles(WirelessNetworkManager.getUserEU(playerMP.func_110124_au()), false), playerMP);
        } else {
            GTValues.NW.sendToPlayer(new GTPacketUpdatePowerGoggles(lastMeasurement.getMeasurement(), lastMeasurement.getCapacity(), false), playerMP);
        }
    }

    public NBTTagCompound getNBT(UUID uuid) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("uuid", uuid.toString());
        if (this.lscLink != null) {
            tag.func_74768_a("x", this.lscLink.x);
            tag.func_74768_a("y", this.lscLink.y);
            tag.func_74768_a("z", this.lscLink.z);
            tag.func_74768_a("dim", this.lscLink.getDimension());
        }
        NBTTagList measurementsTag = new NBTTagList();
        for (PowerGogglesMeasurement measurement : this.measurements) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.addMeasurementToTag(tagCompound, measurement);
            measurementsTag.func_74742_a((NBTBase)tagCompound);
        }
        tag.func_74782_a("measurements", (NBTBase)measurementsTag);
        return tag;
    }

    private void addMeasurementToTag(NBTTagCompound tagCompound, PowerGogglesMeasurement measurement) {
        tagCompound.func_74757_a("isWireless", measurement.isWireless());
        tagCompound.func_74773_a("measurement", measurement.getMeasurement().toByteArray());
        if (!measurement.isWireless()) {
            tagCompound.func_74772_a("capacity", measurement.getCapacity());
        }
    }

    public void measure(EntityPlayerMP playerMP) {
        MTELapotronicSuperCapacitor lsc = PowerGogglesUtil.getLsc(this.lscLink);
        if (lsc == null && this.lscLink != null) {
            return;
        }
        if (lsc == null) {
            this.measurements.addLast(new PowerGogglesMeasurement(true, WirelessNetworkManager.getUserEU(playerMP.func_110124_au())));
        } else {
            this.measurements.addLast(new PowerGogglesMeasurement(false, BigInteger.valueOf(lsc.getEUVar()), lsc.maxEUStore()));
        }
        if (this.measurements.size() > PowerGogglesConstants.STORED_MEASUREMENTS) {
            this.measurements.removeFirst();
        }
        PowerGogglesWorldSavedData.INSTANCE.func_76185_a();
    }

    public void setMeasurements(LinkedList<PowerGogglesMeasurement> measurements) {
        this.measurements = measurements;
    }

    public void overwriteMeasurements(EntityPlayerMP player) {
        GTValues.NW.sendToPlayer(new GTPacketOverwritePowerGogglesMeasurements(this.measurements), player);
    }
}

