/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

public class AverageDouble {
    private double[] data;
    private int pos;
    private int precise;
    private double averageRaw;
    private double tickValue;

    public AverageDouble(int precise) {
        this.precise = precise;
        this.data = new double[precise];
        this.pos = 0;
    }

    public double getAverage() {
        return this.averageRaw / (double)this.precise;
    }

    public void tick(double value) {
        this.internalTick(this.tickValue + value);
        this.tickValue = 0.0;
    }

    public void tick() {
        this.internalTick(this.tickValue);
        this.tickValue = 0.0;
    }

    private void internalTick(double value) {
        ++this.pos;
        this.pos %= this.precise;
        double oldValue = this.data[this.pos];
        this.data[this.pos] = value;
        if (this.pos == 0) {
            this.averageRaw = 0.0;
            for (double iValue : this.data) {
                this.averageRaw += iValue;
            }
        } else {
            this.averageRaw = this.averageRaw - oldValue + value;
        }
    }

    public void push(double value) {
        this.tickValue += value;
    }
}

