/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.robotics.boards;

import buildcraft.api.boards.RedstoneBoardRobot;
import buildcraft.api.boards.RedstoneBoardRobotNBT;
import buildcraft.api.robots.AIRobot;
import buildcraft.api.robots.EntityRobotBase;
import buildcraft.core.lib.inventory.filters.IStackFilter;
import buildcraft.core.lib.utils.IEntityFilter;
import buildcraft.robotics.ai.AIRobotAttack;
import buildcraft.robotics.ai.AIRobotFetchAndEquipItemStack;
import buildcraft.robotics.ai.AIRobotGotoSleep;
import buildcraft.robotics.ai.AIRobotGotoStationAndUnload;
import buildcraft.robotics.ai.AIRobotSearchEntity;
import buildcraft.robotics.boards.BCBoardNBT;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;

public class BoardRobotButcher
extends RedstoneBoardRobot {
    public BoardRobotButcher(EntityRobotBase iRobot) {
        super(iRobot);
    }

    @Override
    public RedstoneBoardRobotNBT getNBTHandler() {
        return BCBoardNBT.REGISTRY.get("butcher");
    }

    @Override
    public final void update() {
        if (this.robot.func_70694_bm() == null) {
            this.startDelegateAI(new AIRobotFetchAndEquipItemStack(this.robot, new IStackFilter(){

                @Override
                public boolean matches(ItemStack stack) {
                    return stack.func_77973_b() instanceof ItemSword;
                }
            }));
        } else if (this.robot.func_70694_bm() != null && this.robot.func_70694_bm().func_77960_j() >= this.robot.func_70694_bm().func_77958_k()) {
            this.startDelegateAI(new AIRobotGotoStationAndUnload(this.robot));
        } else {
            this.startDelegateAI(new AIRobotSearchEntity(this.robot, new IEntityFilter(){

                @Override
                public boolean matches(Entity entity) {
                    return entity instanceof EntityAnimal;
                }
            }, 250.0f, this.robot.getZoneToWork()));
        }
    }

    @Override
    public void delegateAIEnded(AIRobot ai) {
        if (ai instanceof AIRobotFetchAndEquipItemStack) {
            if (!ai.success()) {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        } else if (ai instanceof AIRobotSearchEntity) {
            if (ai.success()) {
                this.startDelegateAI(new AIRobotAttack(this.robot, ((AIRobotSearchEntity)ai).target));
            } else {
                this.startDelegateAI(new AIRobotGotoSleep(this.robot));
            }
        }
    }
}

