/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.gui.misc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.ChunkCoordIntPair;
import serverutils.lib.client.CachedVertexData;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.Button;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.Theme;
import serverutils.lib.gui.Widget;
import serverutils.lib.gui.WidgetLayout;
import serverutils.lib.gui.misc.ChunkSelectorMap;
import serverutils.lib.icon.Color4I;
import serverutils.lib.math.MathUtils;
import serverutils.lib.util.misc.MouseButton;

public class GuiChunkSelectorBase
extends GuiBase {
    public static final int TILE_SIZE = 12;
    private static final CachedVertexData GRID = new CachedVertexData(1, false, true, false);
    public int startX;
    public int startZ;
    private final MapButton[] mapButtons;
    private final Panel panelButtons;
    public int currentSelectionMode = -1;
    public boolean blockMode = false;
    public int anchorIndex = -1;
    public int mouseIndex = -1;

    public GuiChunkSelectorBase() {
        this.startX = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70165_t) - 7;
        this.startZ = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70161_v) - 7;
        this.panelButtons = new Panel(this){

            @Override
            public void addWidgets() {
                GuiChunkSelectorBase.this.addCornerButtons(GuiChunkSelectorBase.this.panelButtons);
            }

            @Override
            public void alignWidgets() {
                int h = this.align(WidgetLayout.VERTICAL);
                int w = 0;
                for (Widget widget : this.widgets) {
                    w = Math.max(w, widget.width);
                }
                GuiChunkSelectorBase.this.panelButtons.setPosAndSize(this.getGui().width + 2, -2, w, h);
            }
        };
        this.mapButtons = new MapButton[225];
        for (int i = 0; i < this.mapButtons.length; ++i) {
            this.mapButtons[i] = new MapButton(this, i);
        }
    }

    @Override
    public boolean onInit() {
        ChunkSelectorMap.getMap().resetMap(this.startX, this.startZ);
        return true;
    }

    @Override
    public void addWidgets() {
        for (MapButton b : this.mapButtons) {
            this.add(b);
        }
        this.add(this.panelButtons);
    }

    @Override
    public void alignWidgets() {
        this.setSize(180, 180);
        this.panelButtons.alignWidgets();
    }

    @Override
    public void drawBackground(Theme theme, int x, int y, int w, int h) {
        int currentStartX = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70165_t) - 7;
        int currentStartZ = MathUtils.chunk(Minecraft.func_71410_x().field_71439_g.field_70161_v) - 7;
        if (currentStartX != this.startX || currentStartZ != this.startZ) {
            this.startX = currentStartX;
            this.startZ = currentStartZ;
            for (int i = 0; i < this.mapButtons.length; ++i) {
                this.mapButtons[i] = new MapButton(this, i);
            }
            ChunkSelectorMap.getMap().resetMap(this.startX, this.startZ);
        }
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        Color4I.BLACK.draw(x - 2, y - 2, w + 4, h + 4);
        ChunkSelectorMap.getMap().drawMap(this, x, y, this.startX, this.startZ);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        for (MapButton mapButton : this.mapButtons) {
            mapButton.draw(theme, mapButton.getX(), mapButton.getY(), mapButton.width, mapButton.height);
        }
        GlStateManager.disableTexture2D();
        GlStateManager.glLineWidth(1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78373_b((double)this.mapButtons[0].getX(), (double)this.mapButtons[0].getY(), 0.0);
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
        if (!GuiChunkSelectorBase.isKeyDown(15)) {
            this.drawArea(tessellator);
        }
        GRID.draw(tessellator);
        tessellator.func_78373_b(0.0, 0.0, 0.0);
        GlStateManager.enableTexture2D();
        GlStateManager.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void mouseReleased(MouseButton button) {
        super.mouseReleased(button);
        if (this.currentSelectionMode != -1) {
            ArrayList<ChunkCoordIntPair> c = new ArrayList<ChunkCoordIntPair>();
            for (MapButton b : this.mapButtons) {
                if (!b.isSelected) continue;
                c.add(b.chunkPos);
                b.isSelected = false;
            }
            this.onChunksSelected(c);
            this.currentSelectionMode = -1;
            this.anchorIndex = -1;
            this.mouseIndex = -1;
            this.blockMode = false;
        }
    }

    @Override
    public void drawForeground(Theme theme, int x, int y, int w, int h) {
        int i;
        int lineSpacing = theme.getFontHeight() + 1;
        ArrayList<String> tempTextList = new ArrayList<String>();
        this.addCornerText(tempTextList, Corner.BOTTOM_RIGHT);
        for (i = 0; i < tempTextList.size(); ++i) {
            String s = (String)tempTextList.get(i);
            theme.drawString(s, this.getScreen().func_78326_a() - theme.getStringWidth(s) - 2, this.getScreen().func_78328_b() - (tempTextList.size() - i) * lineSpacing, 2);
        }
        tempTextList.clear();
        this.addCornerText(tempTextList, Corner.BOTTOM_LEFT);
        for (i = 0; i < tempTextList.size(); ++i) {
            theme.drawString((String)tempTextList.get(i), 2, this.getScreen().func_78328_b() - (tempTextList.size() - i) * lineSpacing, 2);
        }
        tempTextList.clear();
        this.addCornerText(tempTextList, Corner.TOP_LEFT);
        for (i = 0; i < tempTextList.size(); ++i) {
            theme.drawString((String)tempTextList.get(i), 2, 2 + i * lineSpacing, 2);
        }
        super.drawForeground(theme, x, y, w, h);
    }

    public int getSelectionMode(MouseButton button) {
        return -1;
    }

    public void onChunksSelected(Collection<ChunkCoordIntPair> chunks) {
    }

    public void drawArea(Tessellator tessellator) {
    }

    public void addCornerButtons(Panel panel) {
    }

    public void addCornerText(List<String> list, Corner corner) {
    }

    public void addButtonText(MapButton button, List<String> list) {
    }

    static {
        GuiChunkSelectorBase.GRID.color.set(128, 128, 128, 50);
        for (int x = 0; x <= 15; ++x) {
            GRID.pos(x * 12, 0.0);
            GRID.pos(x * 12, 180.0, 0.0);
        }
        for (int y = 0; y <= 15; ++y) {
            GRID.pos(0.0, y * 12, 0.0);
            GRID.pos(180.0, y * 12, 0.0);
        }
    }

    public static class MapButton
    extends Button {
        public final GuiChunkSelectorBase gui;
        public final ChunkCoordIntPair chunkPos;
        public final int index;
        private boolean isSelected = false;

        private MapButton(GuiChunkSelectorBase g, int i) {
            super(g);
            this.gui = g;
            this.index = i;
            this.setPosAndSize(this.index % 15 * 12, this.index / 15 * 12, 12, 12);
            this.chunkPos = new ChunkCoordIntPair(this.gui.startX + i % 15, this.gui.startZ + i / 15);
        }

        @Override
        public void onClicked(MouseButton button) {
            GuiHelper.playClickSound();
            this.gui.currentSelectionMode = this.gui.getSelectionMode(button);
            if (this.gui.blockMode) {
                this.gui.anchorIndex = this.index;
                this.gui.mouseIndex = this.index;
            }
            if (this.gui.currentSelectionMode == -1) {
                this.gui.onChunksSelected(Collections.singleton(this.chunkPos));
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            this.gui.addButtonText(this, list);
        }

        @Override
        public void draw(Theme theme, int x, int y, int w, int h) {
            if (this.gui.currentSelectionMode != -1) {
                if (this.gui.blockMode && this.gui.anchorIndex >= 0 && this.gui.mouseIndex >= 0) {
                    if (this.gui.isMouseOver(this)) {
                        this.gui.mouseIndex = this.index;
                    }
                    ChunkCoordIntPair anchorChunk = ((GuiChunkSelectorBase)this.gui).mapButtons[this.gui.anchorIndex].chunkPos;
                    ChunkCoordIntPair mouseChunk = ((GuiChunkSelectorBase)this.gui).mapButtons[this.gui.mouseIndex].chunkPos;
                    this.isSelected = MathUtils.isNumberBetween(this.chunkPos.field_77276_a, anchorChunk.field_77276_a, mouseChunk.field_77276_a) && MathUtils.isNumberBetween(this.chunkPos.field_77275_b, anchorChunk.field_77275_b, mouseChunk.field_77275_b);
                } else if (!this.isSelected && this.gui.isMouseOver(this)) {
                    this.isSelected = true;
                }
            }
            if (this.isSelected || this.gui.isMouseOver(this)) {
                Color4I.WHITE.withAlpha(33).draw(x, y, 12, 12);
            }
        }
    }

    protected static enum Corner {
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_LEFT;

    }
}

