/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.minecraft.util.StatCollector;

public class ImageSplitDialog
extends JDialog {
    private static final long serialVersionUID = 4914010465453075645L;
    private final JPanel contentPanel = new JPanel();
    private JLabel imageLabel;
    public BufferedImage imageSection;
    private BufferedImage image;
    private JSlider y2slider;
    private JSlider x2slider;
    private JSlider x1slider;
    private JSlider y1slider;

    public ImageSplitDialog(BufferedImage bi) {
        this.setBounds(100, 100, 453, 470);
        this.image = bi;
        this.setModal(true);
        this.setAlwaysOnTop(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.contentPanel, "Center");
        JLabel lblNewLabel = new JLabel(StatCollector.func_74838_a((String)"gui.splitter.number.x.sections"));
        lblNewLabel.setHorizontalAlignment(0);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(0, 0));
        this.imageLabel = new JLabel("");
        panel.add((Component)this.imageLabel, "Center");
        this.x2slider = new JSlider();
        this.x2slider.setValue(1);
        this.x2slider.setPaintTicks(true);
        this.x2slider.setSnapToTicks(true);
        this.x2slider.setPaintLabels(true);
        this.x2slider.setMajorTickSpacing(1);
        this.x2slider.setMinorTickSpacing(1);
        this.x2slider.setMinimum(1);
        this.x2slider.setMaximum(4);
        this.x1slider = new JSlider();
        this.x1slider.setValue(4);
        this.x1slider.setSnapToTicks(true);
        this.x1slider.setPaintTicks(true);
        this.x1slider.setPaintLabels(true);
        this.x1slider.setMinorTickSpacing(1);
        this.x1slider.setMinimum(1);
        this.x1slider.setMaximum(4);
        this.x1slider.setMajorTickSpacing(1);
        JLabel lblNewLabel_1 = new JLabel(StatCollector.func_74838_a((String)"gui.splitter.x.section"));
        lblNewLabel_1.setHorizontalAlignment(0);
        this.y2slider = new JSlider();
        this.y2slider.setValue(1);
        this.y2slider.setInverted(true);
        this.y2slider.setMajorTickSpacing(1);
        this.y2slider.setMinorTickSpacing(1);
        this.y2slider.setMinimum(1);
        this.y2slider.setMaximum(4);
        this.y2slider.setSnapToTicks(true);
        this.y2slider.setPaintTicks(true);
        this.y2slider.setPaintLabels(true);
        this.y2slider.setOrientation(1);
        JLabel lblYSection = new JLabel(StatCollector.func_74838_a((String)"gui.splitter.y.section"));
        lblYSection.setHorizontalAlignment(0);
        this.y1slider = new JSlider();
        this.y1slider.setValue(4);
        this.y1slider.setSnapToTicks(true);
        this.y1slider.setPaintTicks(true);
        this.y1slider.setPaintLabels(true);
        this.y1slider.setOrientation(1);
        this.y1slider.setMinorTickSpacing(1);
        this.y1slider.setMinimum(1);
        this.y1slider.setMaximum(4);
        this.y1slider.setMajorTickSpacing(1);
        String[] split = StatCollector.func_74838_a((String)"gui.splitter.number.y.sections").split("\\*");
        JLabel lblNewLabel_2 = new JLabel();
        JLabel lblYSections = new JLabel();
        if (split.length > 1) {
            lblNewLabel_2.setText(split[0]);
            lblYSections.setText(split[1]);
        } else {
            lblYSections.setText(split[0]);
        }
        lblNewLabel_2.setHorizontalAlignment(0);
        lblYSections.setHorizontalAlignment(0);
        GroupLayout gl_contentPanel = new GroupLayout(this.contentPanel);
        gl_contentPanel.setHorizontalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(lblNewLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.x1slider, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(lblNewLabel_1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.x2slider, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(panel, GroupLayout.Alignment.LEADING, -1, 226, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.y2slider, -1, -1, Short.MAX_VALUE).addComponent(lblYSection, -1, 77, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(lblNewLabel_2, -1, -1, Short.MAX_VALUE).addComponent(this.y1slider, -1, 77, Short.MAX_VALUE).addComponent(lblYSections, -1, -1, Short.MAX_VALUE)).addContainerGap(44, Short.MAX_VALUE)));
        gl_contentPanel.setVerticalGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(gl_contentPanel.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(lblNewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.x1slider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(lblNewLabel_1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(gl_contentPanel.createSequentialGroup().addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.x2slider, -2, -1, -2).addComponent(lblYSection).addGroup(gl_contentPanel.createSequentialGroup().addComponent(lblNewLabel_2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(lblYSections))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(gl_contentPanel.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.y2slider, -1, 220, Short.MAX_VALUE).addComponent(panel, -2, 220, -2))).addComponent(this.y1slider, GroupLayout.Alignment.TRAILING, -2, 220, -2)).addContainerGap()));
        this.x1slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                ImageSplitDialog.this.x2slider.setMaximum(source.getValue());
                ImageSplitDialog.this.resetImage();
            }
        });
        this.x2slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImageSplitDialog.this.resetImage();
            }
        });
        this.y1slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JSlider source = (JSlider)e.getSource();
                ImageSplitDialog.this.y2slider.setMaximum(source.getValue());
                ImageSplitDialog.this.resetImage();
            }
        });
        this.y2slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ImageSplitDialog.this.resetImage();
            }
        });
        this.contentPanel.setLayout(gl_contentPanel);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)buttonPane, "South");
        JButton okButton = new JButton("OK");
        buttonPane.add(okButton);
        this.getRootPane().setDefaultButton(okButton);
        okButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = -411321897339497163L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageSplitDialog.this.imageSection = ImageSplitDialog.this.image.getSubimage((int)((float)(ImageSplitDialog.this.getX2slider().getValue() - 1) / (float)ImageSplitDialog.this.getX1slider().getValue() * (float)ImageSplitDialog.this.image.getWidth()), (int)((float)(ImageSplitDialog.this.getY2slider().getValue() - 1) / (float)ImageSplitDialog.this.getY1slider().getValue() * (float)ImageSplitDialog.this.image.getHeight()), (int)((float)(ImageSplitDialog.this.image.getWidth() / ImageSplitDialog.this.getX1slider().getValue())), (int)((float)(ImageSplitDialog.this.image.getHeight() / ImageSplitDialog.this.getY1slider().getValue())));
                ImageSplitDialog.this.setVisible(false);
            }
        });
        JButton cancelButton = new JButton("Cancel");
        buttonPane.add(cancelButton);
        cancelButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 3898343682430933752L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageSplitDialog.this.setVisible(false);
            }
        });
        this.resetImage();
    }

    private void resetImage() {
        BufferedImage before;
        BufferedImage scaled = before = this.image.getSubimage(0, 0, this.image.getWidth(), this.image.getHeight());
        int width = 250;
        int height = 250;
        if (before.getWidth() != width || before.getHeight() != height) {
            scaled = new BufferedImage(width, height, 2);
            AffineTransform at = new AffineTransform();
            at.scale((float)width / (float)before.getWidth(), (float)height / (float)before.getHeight());
            AffineTransformOp scaleOp = new AffineTransformOp(at, 3);
            scaled = scaleOp.filter(before, scaled);
        }
        int xBound = 250 / this.getX1slider().getValue();
        int yBound = 250 / this.getY1slider().getValue();
        for (int x = 0; x < width; ++x) {
            int y;
            if (x > xBound * (this.getX2slider().getValue() - 1) && x < xBound * this.getX2slider().getValue()) {
                for (y = 0; y < height; ++y) {
                    if (y > yBound * (this.getY2slider().getValue() - 1) && y < yBound * this.getY2slider().getValue()) continue;
                    scaled.setRGB(x, y, (scaled.getRGB(x, y) & 0xFEFEFE) >> 1 | 0xFF000000);
                }
                continue;
            }
            for (y = 0; y < height; ++y) {
                scaled.setRGB(x, y, (scaled.getRGB(x, y) & 0xFEFEFE) >> 1 | 0xFF000000);
            }
        }
        ImageIcon icon = new ImageIcon(scaled);
        this.imageLabel.setIcon(icon);
    }

    public JSlider getY2slider() {
        return this.y2slider;
    }

    public JSlider getX2slider() {
        return this.x2slider;
    }

    public JSlider getX1slider() {
        return this.x1slider;
    }

    public JSlider getY1slider() {
        return this.y1slider;
    }
}

