/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import makeo.gadomancy.client.util.UtilsFX;
import makeo.gadomancy.common.blocks.tiles.SynchronizedTileEntity;
import makeo.gadomancy.common.entities.EntityPermNoClipItem;
import makeo.gadomancy.common.network.PacketHandler;
import makeo.gadomancy.common.network.packets.PacketStartAnimation;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.command.IEntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.common.entities.EntityPermanentItem;
import thaumcraft.common.entities.EntitySpecialItem;
import thaumcraft.common.items.ItemResearchNotes;
import thaumcraft.common.lib.events.EssentiaHandler;
import thaumcraft.common.lib.research.ResearchManager;
import thaumcraft.common.lib.research.ResearchNoteData;

public class TileKnowledgeBook
extends SynchronizedTileEntity
implements EntityPermNoClipItem.IItemMasterTile,
IAspectContainer {
    private static final Random rand = new Random();
    private static final int LOWEST_AMOUNT = 10;
    private static final int COGNITIO_TICKS = 150;
    private static final int MAX_NEEDED_KNOWLEDGE = 200;
    private static final int SURROUNDINGS_SEARCH_XZ = 4;
    private static final int SURROUNDINGS_SEARCH_Y = 3;
    private static final double MULTIPLIER = 4.0;
    @Deprecated
    public static Map<BlockSnapshot, Integer> knowledgeIncreaseMap = new HashMap<BlockSnapshot, Integer>();
    private FloatingBookAttributes bookAttributes = new FloatingBookAttributes();
    private ItemStack storedResearchNote;
    private EntityPermNoClipItem.ItemChangeTask scheduledTask;
    private int timeSinceLastItemInfo;
    private int ticksExisted;
    private int ticksCognitio;
    private int ticksEnvironmentCheck;
    private int ticksResearchSearch;
    private boolean turnedPagesLastTick;
    private boolean researching;
    private AspectList workResearchAspects;
    private int surroundingKnowledge;

    public void func_145845_h() {
        this.bookAttributes.updateFloatingBook();
        ++this.ticksExisted;
        ++this.timeSinceLastItemInfo;
        if (!this.field_145850_b.field_72995_K) {
            if (this.timeSinceLastItemInfo > 8) {
                this.informItemRemoval();
            }
            if (this.updateResearchStatus()) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
            }
            if (this.researching) {
                this.doResearchCycle();
            }
        } else if (this.researching && this.hasCognitio()) {
            this.doResearchEffects();
        }
        if (this.storedResearchNote == null) {
            this.tryVortexUnfinishedResearchNotes();
        }
    }

    public boolean hasCognitio() {
        return this.ticksCognitio > 0;
    }

    public boolean isResearching() {
        return this.researching;
    }

    private void doResearchCycle() {
        this.drainCognitio();
        if (!this.hasCognitio()) {
            return;
        }
        this.checkSurroundings();
        int chance = Math.max(0, 200 - this.surroundingKnowledge) + 100;
        if (rand.nextInt(chance) == 0) {
            this.doResearchProgress();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        }
    }

    private void doResearchProgress() {
        ArrayList aspects = new ArrayList(this.workResearchAspects.aspects.keySet());
        if (aspects.isEmpty()) {
            this.finishResearch();
            return;
        }
        Aspect a = (Aspect)aspects.get(rand.nextInt(aspects.size()));
        int value = (Integer)this.workResearchAspects.aspects.get(a);
        if (--value <= 0) {
            this.workResearchAspects.aspects.remove(a);
        } else {
            this.workResearchAspects.aspects.put(a, value);
        }
        if (this.workResearchAspects.aspects.isEmpty()) {
            this.finishResearch();
        }
    }

    private void checkSurroundings() {
        if (this.ticksEnvironmentCheck > 0) {
            --this.ticksEnvironmentCheck;
            return;
        }
        this.ticksEnvironmentCheck = 200;
        this.surroundingKnowledge = 0;
        for (int xx = -4; xx <= 4; ++xx) {
            for (int zz = -4; zz <= 4; ++zz) {
                block2: for (int yy = -3; yy <= 3; ++yy) {
                    int absX = xx + this.field_145851_c;
                    int absY = yy + this.field_145848_d;
                    int absZ = zz + this.field_145849_e;
                    Block at = this.field_145850_b.func_147439_a(absX, absY, absZ);
                    int meta = this.field_145850_b.func_72805_g(absX, absY, absZ);
                    TileEntity te = this.field_145850_b.func_147438_o(absX, absY, absZ);
                    if (at.equals(Blocks.field_150342_X)) {
                        ++this.surroundingKnowledge;
                        continue;
                    }
                    if (te != null && te instanceof IKnowledgeProvider) {
                        this.surroundingKnowledge += ((IKnowledgeProvider)te).getProvidedKnowledge(this.field_145850_b, absX, absY, absZ);
                        continue;
                    }
                    if (at instanceof IKnowledgeProvider) {
                        this.surroundingKnowledge += ((IKnowledgeProvider)at).getProvidedKnowledge(this.field_145850_b, absX, absY, absZ);
                        continue;
                    }
                    for (BlockSnapshot sn : knowledgeIncreaseMap.keySet()) {
                        if (!sn.block.equals(at) || sn.metadata != meta) continue;
                        this.surroundingKnowledge += knowledgeIncreaseMap.get(sn).intValue();
                        continue block2;
                    }
                }
            }
        }
    }

    private void drainCognitio() {
        if (this.ticksCognitio <= 0) {
            this.searchForCognitio();
        } else {
            --this.ticksCognitio;
            if (this.ticksCognitio <= 40) {
                this.searchForCognitio();
            }
            if (this.ticksCognitio <= 0) {
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
            }
        }
    }

    private void searchForCognitio() {
        if ((this.ticksExisted & 0x1F) == 0) {
            ForgeDirection[] toTry;
            int drainRange = 4;
            for (ForgeDirection dir : toTry = ForgeDirection.VALID_DIRECTIONS) {
                if (dir == null || !EssentiaHandler.drainEssentia((TileEntity)this, (Aspect)Aspect.MIND, (ForgeDirection)dir, (int)drainRange)) continue;
                this.ticksCognitio += 150;
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.func_70296_d();
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void doResearchEffects() {
        if ((this.ticksExisted & 0xF) == 0) {
            UtilsFX.doRuneEffects((World)Minecraft.func_71410_x().field_71441_e, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, 0);
        }
        if ((this.ticksExisted & 0x1F) == 0) {
            switch (rand.nextInt(5)) {
                case 0: {
                    if (!this.turnedPagesLastTick) {
                        this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.3, (double)this.field_145849_e + 0.5, "thaumcraft:page", 0.4f, 1.0f, false);
                        this.turnedPagesLastTick = true;
                        break;
                    }
                }
                case 1: 
                case 2: 
                case 3: {
                    this.field_145850_b.func_72980_b((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.3, (double)this.field_145849_e + 0.5, "thaumcraft:write", 0.2f, 1.0f, false);
                    this.turnedPagesLastTick = false;
                }
            }
        }
    }

    private void finishResearch() {
        this.stopResearch();
        this.scheduleFinishItemChange();
        PacketStartAnimation packet = new PacketStartAnimation(4, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)packet, this.getTargetPoint(32.0));
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    private NetworkRegistry.TargetPoint getTargetPoint(double radius) {
        return new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, radius);
    }

    private void scheduleFinishItemChange() {
        this.scheduledTask = new EntityPermNoClipItem.ItemChangeTask(){

            @Override
            public void changeItem(EntityPermNoClipItem item) {
                ItemStack stack = item.func_92059_d();
                stack.field_77990_d.func_74757_a("complete", true);
                stack.func_77964_b(64);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean updateResearchStatus() {
        ResearchItem ri;
        ResearchNoteData nd;
        if (this.researching) {
            if (this.storedResearchNote != null) {
                ResearchNoteData nd2 = ResearchManager.getData((ItemStack)this.storedResearchNote);
                if (nd2 != null && !nd2.isComplete()) return false;
                this.stopResearch();
                return true;
            }
            this.stopResearch();
            return true;
        }
        if (this.storedResearchNote == null || (nd = ResearchManager.getData((ItemStack)this.storedResearchNote)) == null || nd.isComplete() || (ri = ResearchCategories.getResearch((String)nd.key)) == null) return false;
        this.beginResearch(ri.tags);
        return true;
    }

    private void beginResearch(AspectList researchTags) {
        AspectList workResearchList = new AspectList();
        for (Aspect a : researchTags.aspects.keySet()) {
            int value = (Integer)researchTags.aspects.get(a);
            int newVal = (int)Math.max(10.0, (double)value * 4.0);
            workResearchList.add(a, newVal);
        }
        this.workResearchAspects = workResearchList;
        this.researching = true;
    }

    private void stopResearch() {
        this.storedResearchNote = null;
        this.workResearchAspects = null;
        this.researching = false;
    }

    @Override
    public boolean canStillHoldItem() {
        return true;
    }

    @Override
    public void informMaster() {
        this.timeSinceLastItemInfo = 0;
    }

    @Override
    public void informItemRemoval() {
        this.storedResearchNote = null;
        this.stopResearch();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.func_70296_d();
    }

    @Override
    public EntityPermNoClipItem.ItemChangeTask getAndRemoveScheduledChangeTask() {
        if (this.scheduledTask != null) {
            EntityPermNoClipItem.ItemChangeTask buffer = this.scheduledTask;
            this.scheduledTask = null;
            return buffer;
        }
        return null;
    }

    @Override
    public void broadcastItemStack(ItemStack itemStack) {
        this.storedResearchNote = itemStack;
    }

    private void tryVortexUnfinishedResearchNotes() {
        if (this.ticksResearchSearch > 0) {
            --this.ticksResearchSearch;
            return;
        }
        float centerY = (float)this.field_145848_d + 0.4f;
        List entityItems = this.field_145850_b.func_82733_a(EntityItem.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)((double)centerY - 0.5), (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)centerY + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(8.0, 8.0, 8.0), new IEntitySelector(){

            public boolean func_82704_a(Entity e) {
                return !(e instanceof EntityPermanentItem) && !(e instanceof EntitySpecialItem) && e instanceof EntityItem && ((EntityItem)e).func_92059_d() != null && ((EntityItem)e).func_92059_d().func_77973_b() instanceof ItemResearchNotes && TileKnowledgeBook.this.shouldVortexResearchNote(((EntityItem)e).func_92059_d());
            }
        });
        EntityItem dummy = new EntityItem(this.field_145850_b);
        dummy.field_70165_t = (double)this.field_145851_c + 0.5;
        dummy.field_70163_u = (double)centerY + 0.5;
        dummy.field_70161_v = (double)this.field_145849_e + 0.5;
        EntityItem entity = null;
        double d0 = Double.MAX_VALUE;
        for (Object entityItem : entityItems) {
            double d1;
            EntityItem entityIt = (EntityItem)entityItem;
            if (entityIt == dummy || !((d1 = dummy.func_70068_e((Entity)entityIt)) <= d0)) continue;
            entity = entityIt;
            d0 = d1;
        }
        if (entity == null) {
            this.ticksResearchSearch = 50;
            return;
        }
        if (dummy.func_70032_d(entity) < 1.0f && !this.field_145850_b.field_72995_K) {
            ItemStack inter = entity.func_92059_d();
            --inter.field_77994_a;
            this.storedResearchNote = inter.func_77946_l();
            this.storedResearchNote.field_77994_a = 1;
            EntityPermNoClipItem item = new EntityPermNoClipItem(entity.field_70170_p, (float)this.field_145851_c + 0.5f, centerY + 0.3f, (float)this.field_145849_e + 0.5f, this.storedResearchNote, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            entity.field_70170_p.func_72838_d((Entity)item);
            item.field_70159_w = 0.0;
            item.field_70181_x = 0.0;
            item.field_70179_y = 0.0;
            item.field_70290_d = entity.field_70290_d;
            item.field_70292_b = entity.field_70292_b;
            item.field_70145_X = true;
            this.timeSinceLastItemInfo = 0;
            if (inter.field_77994_a <= 0) {
                entity.func_70106_y();
            }
            entity.field_70145_X = false;
            item.field_145804_b = 60;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.func_70296_d();
        } else {
            entity.field_70145_X = true;
            this.applyMovementVectors(entity);
        }
    }

    private void applyMovementVectors(EntityItem entity) {
        double var3 = ((double)this.field_145851_c + 0.5 - entity.field_70165_t) / 15.0;
        double var5 = ((double)this.field_145848_d + 0.5 - entity.field_70163_u) / 15.0;
        double var7 = ((double)this.field_145849_e + 0.5 - entity.field_70161_v) / 15.0;
        double var9 = Math.sqrt(var3 * var3 + var5 * var5 + var7 * var7);
        double var11 = 1.0 - var9;
        if (var11 > 0.0) {
            var11 *= var11;
            entity.field_70159_w += var3 / var9 * var11 * 0.15;
            entity.field_70181_x += var5 / var9 * var11 * 0.25;
            entity.field_70179_y += var7 / var9 * var11 * 0.15;
        }
    }

    private boolean shouldVortexResearchNote(ItemStack stack) {
        ResearchNoteData nd = ResearchManager.getData((ItemStack)stack);
        if (nd == null) {
            return false;
        }
        if (nd.isComplete()) {
            return false;
        }
        ResearchItem ri = ResearchCategories.getResearch((String)nd.key);
        return ri != null;
    }

    public FloatingBookAttributes getBookAttributes() {
        return this.bookAttributes;
    }

    @Override
    public void readCustomNBT(NBTTagCompound compound) {
        this.ticksCognitio = compound.func_74762_e("cognitio");
        this.workResearchAspects = NBTHelper.getAspectList(compound, "workAspects");
        this.researching = compound.func_74767_n("researching");
        this.storedResearchNote = NBTHelper.getStack(compound, "crystalStack");
    }

    @Override
    public void writeCustomNBT(NBTTagCompound compound) {
        if (this.workResearchAspects != null) {
            NBTHelper.setAspectList(compound, "workAspects", this.workResearchAspects);
        }
        compound.func_74768_a("cognitio", this.ticksCognitio);
        compound.func_74757_a("researching", this.researching);
        if (this.storedResearchNote != null) {
            NBTHelper.setStack(compound, "crystalStack", this.storedResearchNote);
        }
    }

    public AspectList getAspects() {
        return this.workResearchAspects;
    }

    public void setAspects(AspectList list) {
    }

    public boolean doesContainerAccept(Aspect aspect) {
        return false;
    }

    public int addToContainer(Aspect aspect, int i) {
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int i) {
        return false;
    }

    public boolean takeFromContainer(AspectList list) {
        return false;
    }

    public boolean doesContainerContainAmount(Aspect aspect, int i) {
        return false;
    }

    public boolean doesContainerContain(AspectList list) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        return 0;
    }

    public class FloatingBookAttributes {
        public int field_145926_a;
        public float field_145933_i;
        public float field_145931_j;
        public float field_145932_k;
        public float field_145929_l;
        public float field_145930_m;
        public float field_145927_n;
        public float field_145928_o;
        public float field_145925_p;
        public float field_145924_q;

        private void updateFloatingBook() {
            float f2;
            this.field_145927_n = this.field_145930_m;
            this.field_145925_p = this.field_145928_o;
            EntityPlayer entityplayer = TileKnowledgeBook.this.field_145850_b.func_72977_a((double)((float)TileKnowledgeBook.this.field_145851_c + 0.5f), (double)((float)TileKnowledgeBook.this.field_145848_d + 0.5f), (double)((float)TileKnowledgeBook.this.field_145849_e + 0.5f), 3.0);
            if (entityplayer != null) {
                double d0 = entityplayer.field_70165_t - (double)((float)TileKnowledgeBook.this.field_145851_c + 0.5f);
                double d1 = entityplayer.field_70161_v - (double)((float)TileKnowledgeBook.this.field_145849_e + 0.5f);
                this.field_145924_q = (float)Math.atan2(d1, d0);
                this.field_145930_m += 0.1f;
                if (this.field_145930_m < 0.5f || rand.nextInt(40) == 0) {
                    float f1 = this.field_145932_k;
                    do {
                        this.field_145932_k += (float)(rand.nextInt(4) - rand.nextInt(4));
                    } while (f1 == this.field_145932_k);
                }
            } else {
                this.field_145924_q += 0.02f;
                this.field_145930_m -= 0.1f;
            }
            while (this.field_145928_o >= (float)Math.PI) {
                this.field_145928_o -= (float)Math.PI * 2;
            }
            while (this.field_145928_o < (float)(-Math.PI)) {
                this.field_145928_o += (float)Math.PI * 2;
            }
            while (this.field_145924_q >= (float)Math.PI) {
                this.field_145924_q -= (float)Math.PI * 2;
            }
            while (this.field_145924_q < (float)(-Math.PI)) {
                this.field_145924_q += (float)Math.PI * 2;
            }
            for (f2 = this.field_145924_q - this.field_145928_o; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
            }
            while (f2 < (float)(-Math.PI)) {
                f2 += (float)Math.PI * 2;
            }
            this.field_145928_o += f2 * 0.4f;
            if (this.field_145930_m < 0.0f) {
                this.field_145930_m = 0.0f;
            }
            if (this.field_145930_m > 1.0f) {
                this.field_145930_m = 1.0f;
            }
            ++this.field_145926_a;
            this.field_145931_j = this.field_145933_i;
            float f = (this.field_145932_k - this.field_145933_i) * 0.4f;
            float f3 = 0.2f;
            if (f < -f3) {
                f = -f3;
            }
            if (f > f3) {
                f = f3;
            }
            this.field_145929_l += (f - this.field_145929_l) * 0.9f;
            this.field_145933_i += this.field_145929_l;
        }
    }

    public static interface IKnowledgeProvider {
        public int getProvidedKnowledge(World var1, int var2, int var3, int var4);
    }

    public static class BlockSnapshot {
        public final Block block;
        public final int metadata;

        public BlockSnapshot(Block block, int metadata) {
            this.block = block;
            this.metadata = metadata;
        }
    }
}

