/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityOxStorageModule
extends TileEntityOxygen
implements ISidedInventory,
IFluidHandler {
    public static final int OUTPUT_PER_TICK = 1000;
    public static final int OXYGEN_CAPACITY = 120000;
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledOxygenLevel;
    private int lastScaledOxygenLevel;
    private ItemStack[] containingItems = new ItemStack[1];

    public TileEntityOxStorageModule() {
        super(120000.0f, 40.0f);
        this.storage.setCapacity(0.0f);
        this.storage.setMaxExtract(0.0f);
    }

    public void func_145845_h() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(0)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            float oxygenDraw = Math.min(this.oxygenPerTick * 2.5f, this.maxOxygen - this.storedOxygen);
            this.storedOxygen += oxygenItem.discharge(oxygenItemStack, oxygenDraw);
            if (this.storedOxygen > this.maxOxygen) {
                this.storedOxygen = this.maxOxygen;
            }
        }
        super.func_145845_h();
        this.scaledOxygenLevel = this.getScaledOxygenLevel(16);
        if (this.scaledOxygenLevel != this.lastScaledOxygenLevel) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
        this.produceOxygen(ForgeDirection.getOrientation((int)(this.func_145832_p() - 0 + 2 ^ 1)));
        this.lastScaledOxygenLevel = this.scaledOxygenLevel;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList items = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int index = item.func_74771_c("Slot") & 0xFF;
            if (index >= this.containingItems.length) continue;
            this.containingItems[index] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.containingItems.length; ++i) {
            if (this.containingItems[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.containingItems[i].func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        nbt.func_74782_a("Items", (NBTBase)items);
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public boolean shouldPullEnergy() {
        return false;
    }

    public boolean shouldUseEnergy() {
        return false;
    }

    public ForgeDirection getElectricInputDirection() {
        return null;
    }

    public ItemStack getBatteryInSlot() {
        return null;
    }

    public boolean shouldUseOxygen() {
        return false;
    }

    public float getOxygenProvide(ForgeDirection direction) {
        return this.getOxygenOutputDirection() == direction ? Math.min(1000.0f, this.getOxygenStored()) : 0.0f;
    }

    public EnumSet<ForgeDirection> getOxygenInputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_145832_p() - 0 + 2)));
    }

    public EnumSet<ForgeDirection> getOxygenOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)(this.func_145832_p() - 0 + 2 ^ 1)));
    }

    public ForgeDirection getOxygenOutputDirection() {
        return ForgeDirection.getOrientation((int)(this.func_145832_p() - 0 + 2 ^ 1));
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        ItemStack stack = this.containingItems[index].func_77979_a(count);
        if (this.containingItems[index].field_77994_a == 0) {
            this.containingItems[index] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.OxygenStorageModuleT2.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index == 0 && stack != null && stack.func_77973_b() instanceof IItemOxygenSupply;
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack item, int side) {
        return slotID == 0 && this.func_94041_b(slotID, item) && item.func_77960_j() < item.func_77973_b().func_77612_l();
    }

    public boolean func_102008_b(int slotID, ItemStack item, int side) {
        return slotID == 0 && item != null && FluidUtil.isEmptyContainer((ItemStack)item);
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return from.ordinal() == this.func_145832_p() - 0 + 2 && GalacticraftCore.isPlanetsLoaded && fluid != null && fluid.getName().equals(AsteroidsModule.fluidLiquidOxygen.getName());
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int used = 0;
        if (resource != null && this.canFill(from, resource.getFluid())) {
            used = (int)(this.receiveOxygen((float)resource.amount * 0.09259259f, doFill) / 0.09259259f);
        }
        return used;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        int side;
        FluidTankInfo[] tankInfo = new FluidTankInfo[]{};
        int metaside = this.func_145832_p() - 0 + 2;
        if (metaside == (side = from.ordinal()) && GalacticraftCore.isPlanetsLoaded) {
            tankInfo = new FluidTankInfo[]{new FluidTankInfo(new FluidStack(AsteroidsModule.fluidLiquidOxygen, (int)(this.getOxygenStored() / 0.09259259f)), 1296000)};
        }
        return tankInfo;
    }
}

