/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemDrawers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemCompDrawers
extends ItemDrawers {
    public ItemCompDrawers(Block block) {
        super(block);
    }

    @Override
    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        if (!super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata)) {
            return false;
        }
        TileEntityDrawers tile = (TileEntityDrawers)world.func_147438_o(x, y, z);
        if (tile != null) {
            int initCapacity = StorageDrawers.config.getBlockBaseStorage("compdrawers");
            tile.setDrawerCapacity(initCapacity);
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("tile")) {
                tile.readFromPortableNBT(stack.func_77978_p().func_74775_l("tile"));
            }
            if (side > 1) {
                tile.setDirection(side);
            }
            tile.setIsSealed(false);
        }
        return true;
    }

    @Override
    protected void addDrawersInformation(NBTTagCompound tag, List list) {
        NBTTagList slots = tag.func_150295_c("Slots", 10);
        int totalCount = tag.func_74762_e("Count");
        list.add(EnumChatFormatting.GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.compDrawerList"));
        for (int i = 0; i < slots.func_74745_c(); ++i) {
            NBTTagCompound slot = slots.func_150305_b(i);
            ItemStack stack = this.getItemStackFromDrawer(slot);
            String slotCounter = EnumChatFormatting.YELLOW + " #" + (i + 1) + ": ";
            if (stack != null && tag.func_74764_b("Conv" + i)) {
                int itemCount = totalCount / tag.func_74771_c("Conv" + i);
                list.add(slotCounter + this.getGoodDisplayName(stack) + " " + this.getItemCountDisplay(stack.func_77976_d(), itemCount));
                continue;
            }
            list.add(slotCounter + EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"storageDrawers.drawers.sealed.drawerEmpty"));
        }
    }
}

