/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.gtnhlib.core.transformer;

import com.gtnewhorizon.gtnhlib.asm.ClassConstantPoolParser;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class TessellatorRedirectorTransformer
implements IClassTransformer {
    private static final String TessellatorClass = "net/minecraft/client/renderer/Tessellator";
    private static final ClassConstantPoolParser cstPoolParser = new ClassConstantPoolParser("net/minecraft/client/renderer/Tessellator");
    private static final List<String> TransformerExclusions = Arrays.asList("org.lwjgl", "com.gtnewhorizons.angelica.glsm.", "com.gtnewhorizons.angelica.transform", "me.eigenraven.lwjgl3ify", "com.gtnewhorizon.gtnhlib", "net.minecraft.client.renderer.Tessellator");

    public static List<String> getTransformerExclusions() {
        return Collections.unmodifiableList(TransformerExclusions);
    }

    public boolean shouldRfbTransform(byte[] basicClass) {
        return cstPoolParser.find(basicClass, true);
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        for (String exclusion : TransformerExclusions) {
            if (!transformedName.startsWith(exclusion)) continue;
            return basicClass;
        }
        if (!cstPoolParser.find(basicClass, true)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        boolean changed = this.transformClassNode(transformedName, cn);
        if (changed) {
            ClassWriter cw = new ClassWriter(1);
            cn.accept((ClassVisitor)cw);
            return cw.toByteArray();
        }
        return basicClass;
    }

    public boolean transformClassNode(String transformedName, ClassNode cn) {
        if (cn == null) {
            return false;
        }
        boolean changed = false;
        for (MethodNode mn : cn.methods) {
            if (transformedName.equals("net.minecraft.client.renderer.OpenGlHelper") && (mn.name.equals("glBlendFunc") || mn.name.equals("func_148821_a"))) continue;
            for (AbstractInsnNode node : mn.instructions.toArray()) {
                if (node.getOpcode() != 178 || !(node instanceof FieldInsnNode)) continue;
                FieldInsnNode fNode = (FieldInsnNode)node;
                if (!fNode.name.equals("field_78398_a") && !fNode.name.equals("instance") || !fNode.owner.equals(TessellatorClass)) continue;
                mn.instructions.set(node, (AbstractInsnNode)new MethodInsnNode(184, "com/gtnewhorizon/gtnhlib/client/renderer/TessellatorManager", "get", "()Lnet/minecraft/client/renderer/Tessellator;", false));
                changed = true;
            }
        }
        return changed;
    }
}

