/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import com.google.gson.annotations.SerializedName;
import com.recursive_pineapple.matter_manipulator.common.building.BlockAnalyzer;
import com.recursive_pineapple.matter_manipulator.common.building.ITileAnalysisIntegration;
import com.recursive_pineapple.matter_manipulator.common.building.PortableItemStack;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.common.shape.Shape;
import gcewing.architecture.common.tile.TileShape;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.MetaBlockState;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class ArchitectureCraftAnalysisResult
implements ITileAnalysisIntegration {
    @SerializedName(value="s")
    public int shape;
    @SerializedName(value="m")
    public PortableItemStack material;
    @SerializedName(value="c")
    public PortableItemStack cladding;

    public static ArchitectureCraftAnalysisResult analyze(TileEntity te) {
        if (!(te instanceof TileShape)) {
            return null;
        }
        TileShape tileShape = (TileShape)te;
        ArchitectureCraftAnalysisResult result = new ArchitectureCraftAnalysisResult();
        result.shape = tileShape.shape.id;
        result.material = new PortableItemStack(new ItemStack(tileShape.baseBlockState.getBlock(), 0, BlockCompatUtils.getMetaFromBlockState((IBlockState)tileShape.baseBlockState)));
        if (tileShape.secondaryBlockState != null) {
            result.cladding = new PortableItemStack(new ItemStack(tileShape.secondaryBlockState.getBlock(), 0, BlockCompatUtils.getMetaFromBlockState((IBlockState)tileShape.secondaryBlockState)));
        }
        return result;
    }

    @Override
    public boolean apply(BlockAnalyzer.IBlockApplyContext ctx) {
        TileEntity te = ctx.getTileEntity();
        if (te instanceof TileShape) {
            TileShape tileShape = (TileShape)te;
            if (tileShape.secondaryBlockState != null) {
                this.removeCladding(ctx, tileShape, false);
            }
            if (this.cladding != null && !this.addCladding(ctx, tileShape, false)) {
                return false;
            }
            tileShape.markChanged();
            return true;
        }
        return false;
    }

    @Override
    public boolean getRequiredItemsForExistingBlock(BlockAnalyzer.IBlockApplyContext context) {
        TileEntity te = context.getTileEntity();
        if (te instanceof TileShape) {
            TileShape tileShape = (TileShape)te;
            this.removeCladding(context, tileShape, true);
            return this.cladding == null || this.addCladding(context, tileShape, true);
        }
        return false;
    }

    @Override
    public boolean getRequiredItemsForNewBlock(BlockAnalyzer.IBlockApplyContext context) {
        if (this.cladding != null) {
            this.addCladding(context, null, true);
        }
        return true;
    }

    private void removeCladding(BlockAnalyzer.IBlockApplyContext context, TileShape tileShape, boolean simulate) {
        IBlockState existingCladding = tileShape.secondaryBlockState;
        if (existingCladding == null) {
            return;
        }
        Block block = existingCladding.getBlock();
        int meta = BlockCompatUtils.getMetaFromBlockState((IBlockState)existingCladding);
        context.givePlayerItems(ArchitectureCraft.content.itemCladding.newStack(block, meta, 1));
        if (!simulate) {
            tileShape.secondaryBlockState = null;
            tileShape.markChanged();
        }
    }

    private boolean addCladding(BlockAnalyzer.IBlockApplyContext context, TileShape tileShape, boolean simulate) {
        Block block = this.cladding.getBlock();
        if (block == null) {
            return false;
        }
        ItemStack claddingStack = ArchitectureCraft.content.itemCladding.newStack(block, this.cladding.getMeta(), 1);
        if (!context.tryConsumeItems(claddingStack)) {
            if (!simulate) {
                context.warn("Could not find cladding: " + claddingStack.func_82833_r());
            }
            return false;
        }
        if (!simulate) {
            tileShape.secondaryBlockState = new MetaBlockState(block, this.cladding.getMeta());
            tileShape.markChanged();
        }
        return true;
    }

    @Override
    public void getItemTag(NBTTagCompound tag) {
        tag.func_74778_a("BaseName", this.material.item.toString());
        tag.func_74768_a("BaseData", this.material.getMeta());
        tag.func_74768_a("Shape", this.shape);
    }

    @Override
    public void getItemDetails(List<String> details) {
        ItemStack stack;
        Shape shape = Shape.forId((int)this.shape);
        if (shape != null) {
            details.add(shape.title);
        }
        ItemStack itemStack = stack = this.material == null ? null : this.material.toStack();
        if (stack != null) {
            details.add(stack.func_82833_r());
        }
    }

    @Override
    public void transform(Transform transform) {
    }

    @Override
    public void migrate() {
    }

    @Override
    public ArchitectureCraftAnalysisResult clone() {
        ArchitectureCraftAnalysisResult dup = new ArchitectureCraftAnalysisResult();
        dup.shape = this.shape;
        dup.material = this.material == null ? null : this.material.clone();
        dup.cladding = this.cladding == null ? null : this.cladding.clone();
        return dup;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.shape;
        result = 31 * result + (this.material == null ? 0 : this.material.hashCode());
        result = 31 * result + (this.cladding == null ? 0 : this.cladding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArchitectureCraftAnalysisResult other = (ArchitectureCraftAnalysisResult)obj;
        if (this.shape != other.shape) {
            return false;
        }
        if (this.material == null ? other.material != null : !this.material.equals(other.material)) {
            return false;
        }
        return !(this.cladding == null ? other.cladding != null : !this.cladding.equals(other.cladding));
    }

    public String toString() {
        return "ArchitectureCraftAnalysisResult [shape=" + this.shape + ", material=" + this.material + ", cladding=" + this.cladding + "]";
    }
}

