/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.drawable.text.StringKey;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.widget.Widget;
import com.cleanroommc.modularui.widget.WidgetTree;
import com.cleanroommc.modularui.widget.sizer.Box;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.Nullable;

public class TextWidget
extends Widget<TextWidget> {
    private final IKey key;
    private Alignment alignment = Alignment.CenterLeft;
    private Integer color = null;
    private Boolean shadow = null;
    private float scale = 1.0f;
    private String lastText = null;
    private String textForDefaultSize = null;

    public TextWidget(IKey key) {
        this.key = key;
    }

    public TextWidget(String key) {
        this(new StringKey(key));
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        TextRenderer renderer = TextRenderer.SHARED;
        String text = this.key.getFormatted();
        if (this.lastText != null && !this.lastText.equals(text)) {
            WidgetTree.resizeInternal(this, false);
        }
        this.lastText = text;
        renderer.setColor(this.color != null ? this.color.intValue() : widgetTheme.getTextColor());
        renderer.setAlignment(this.alignment, (float)this.getArea().w() + this.scale, this.getArea().h());
        renderer.setShadow(this.shadow != null ? this.shadow.booleanValue() : widgetTheme.getTextShadow());
        renderer.setPos(this.getArea().getPadding().left, this.getArea().getPadding().top);
        renderer.setScale(this.scale);
        renderer.setSimulate(false);
        renderer.draw(this.key.getFormatted());
    }

    private TextRenderer simulate(float maxWidth) {
        Box padding = this.getArea().getPadding();
        TextRenderer renderer = TextRenderer.SHARED;
        renderer.setAlignment(Alignment.TopLeft, maxWidth);
        renderer.setPos(padding.left, padding.top);
        renderer.setScale(this.scale);
        renderer.setSimulate(true);
        renderer.draw(this.getTextForDefaultSize());
        renderer.setSimulate(false);
        return renderer;
    }

    @Override
    public int getDefaultHeight() {
        float maxWidth = this.resizer().isWidthCalculated() ? (float)this.getArea().width + this.scale : (this.getParent().resizer().isWidthCalculated() ? (float)this.getParent().getArea().width + this.scale : (float)this.getScreen().getScreenArea().width);
        TextRenderer renderer = this.simulate(maxWidth);
        return this.getWidgetHeight(renderer.getLastActualHeight());
    }

    @Override
    public int getDefaultWidth() {
        float maxWidth = this.getScreen().getScreenArea().width;
        if (this.getParent().resizer().isWidthCalculated()) {
            maxWidth = this.getParent().getArea().width;
        }
        TextRenderer renderer = this.simulate(maxWidth);
        return this.getWidgetWidth(renderer.getLastActualWidth());
    }

    protected int getWidgetWidth(float actualTextWidth) {
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)Math.ceil(actualTextWidth + (float)padding.horizontal()));
    }

    protected int getWidgetHeight(float actualTextHeight) {
        Box padding = this.getArea().getPadding();
        return Math.max(1, (int)Math.ceil(actualTextHeight + (float)padding.vertical()));
    }

    protected String getTextForDefaultSize() {
        if (this.textForDefaultSize == null) {
            this.lastText = this.textForDefaultSize = this.key.getFormatted();
        }
        return this.textForDefaultSize;
    }

    @Override
    public void postResize() {
        this.textForDefaultSize = null;
    }

    public IKey getKey() {
        return this.key;
    }

    public Alignment getAlignment() {
        return this.alignment;
    }

    public float getScale() {
        return this.scale;
    }

    @Nullable
    public Integer getColor() {
        return this.color;
    }

    @Nullable
    public Boolean isShadow() {
        return this.shadow;
    }

    public TextWidget alignment(Alignment alignment) {
        this.alignment = alignment;
        return this;
    }

    public TextWidget color(@Nullable Integer color) {
        this.color = color;
        return this;
    }

    public TextWidget scale(float scale) {
        this.scale = scale;
        return this;
    }

    public TextWidget shadow(@Nullable Boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public TextWidget style(EnumChatFormatting formatting) {
        this.key.style(formatting);
        return this;
    }
}

