/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.util;

import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.BlockPosM;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.MathUtil;
import java.lang.reflect.Array;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public final class DragonUtil {
    public static int portalEffectX;
    public static int portalEffectZ;
    public static final DecimalFormat formatOnePlace;
    public static final DecimalFormat formatTwoPlaces;
    private static final Pattern regexChatFormatting;
    private static final double[] rayX;
    private static final double[] rayZ;

    public static boolean canEntitySeePoint(EntityLivingBase entity, double x, double y, double z, double pointScale) {
        return DragonUtil.canEntitySeePoint(entity, x, y, z, pointScale, false);
    }

    public static boolean canEntitySeePoint(EntityLivingBase entity, double x, double y, double z, double pointScale, boolean fromCenter) {
        boolean isYInPitch;
        Stopwatch.timeAverage("DragonUtil - canEntitySeePoint", 800);
        double px = entity.field_70165_t;
        double py = entity.field_70163_u;
        double pz = entity.field_70161_v;
        double ry = -entity.field_70177_z;
        double rp = -entity.field_70125_A;
        if (!fromCenter) {
            px -= MathUtil.lendirx(1.5, ry);
            pz -= MathUtil.lendiry(1.5, ry);
        }
        int t1x = (int)(px + MathUtil.lendirx(600.0, ry - 66.0));
        int t1z = (int)(pz + MathUtil.lendiry(600.0, ry - 66.0));
        int t2x = (int)(px + MathUtil.lendirx(600.0, ry + 66.0));
        int t2z = (int)(pz + MathUtil.lendiry(600.0, ry + 66.0));
        boolean isXZInYaw = MathUtil.triangle((int)x, (int)z, (int)px, (int)pz, t1x, t1z, t2x, t2z);
        if (Math.abs(rp) < 70.0 && Math.abs(y - py) <= 2.0 || Math.abs(y - py) > 2.0) {
            isYInPitch = true;
        } else {
            int t3y = (int)(py + MathUtil.lendirx(28.0, rp - 60.0));
            int t4y = (int)(py + MathUtil.lendirx(28.0, rp + 60.0));
            isYInPitch = y >= (double)t3y && y <= (double)t4y;
        }
        boolean[] isBlockedArr = new boolean[8];
        for (int a = 0; a < 4; ++a) {
            for (int b = 0; b < 2; ++b) {
                MovingObjectPosition mop = entity.field_70170_p.func_72933_a(Vec3.func_72443_a((double)px, (double)(py + (double)0.12f), (double)pz), Vec3.func_72443_a((double)(x + rayX[a] * pointScale), (double)(y + (b == 0 ? -1.0 : 1.0) * pointScale), (double)(z + rayZ[a] * pointScale)));
                if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) continue;
                boolean bl = isBlockedArr[a * 2 + b] = MathUtil.distance((double)mop.field_72311_b + 0.5 - x, (double)mop.field_72312_c + 0.5 - y, (double)mop.field_72309_d + 0.5 - z) > 0.1 && MathUtil.distance((double)mop.field_72311_b + 0.5 - px, (double)mop.field_72312_c + 0.62 - py, (double)mop.field_72309_d - pz) > 2.0;
                if (!isBlockedArr[a * 2 + b] || entity.field_70170_p.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d).func_149662_c()) continue;
                isBlockedArr[a * 2 + b] = false;
            }
        }
        boolean isBlocked = isBlockedArr[0] && isBlockedArr[1] && isBlockedArr[2] && isBlockedArr[3] && isBlockedArr[4] && isBlockedArr[5] && isBlockedArr[6] && isBlockedArr[7];
        Stopwatch.finish("DragonUtil - canEntitySeePoint");
        if (isBlocked) {
            return false;
        }
        return isXZInYaw && isYInPitch;
    }

    public static float rotateSmoothly(float sourceAngle, float targetAngle, float amount) {
        while (sourceAngle < 0.0f) {
            sourceAngle += 360.0f;
        }
        while (sourceAngle >= 360.0f) {
            sourceAngle -= 360.0f;
        }
        float angleDifference = 180.0f - Math.abs(Math.abs(sourceAngle - targetAngle) - 180.0f);
        if (angleDifference <= amount) {
            return targetAngle;
        }
        float d = sourceAngle < 180.0f ? sourceAngle + 180.0f : sourceAngle - 180.0f;
        return sourceAngle += amount * (float)(targetAngle > d && targetAngle < sourceAngle || sourceAngle < 180.0f && (targetAngle > d || targetAngle < sourceAngle) ? -1 : 1);
    }

    public static <T extends Entity> T getClosestEntity(Entity source, List<? extends T> list) {
        double closestDist = Double.MAX_VALUE;
        Entity closestEntity = null;
        for (Entity entity : list) {
            double d;
            if (entity.field_70128_L || entity == source) continue;
            double currentDist = source.func_70068_e(entity);
            if (!(d < closestDist)) continue;
            closestDist = currentDist;
            closestEntity = entity;
        }
        return (T)closestEntity;
    }

    public static <T extends Entity> List<T> getClosestEntities(int maxAmount, Entity source, List<? extends T> list) {
        ArrayList<Entity> closestEntities = new ArrayList<Entity>();
        HashMap<Entity, Float> entities = new HashMap<Entity, Float>();
        if (maxAmount <= 0) {
            return closestEntities;
        }
        for (Entity entity : list) {
            if (entity.field_70128_L || entity == source) continue;
            entities.put(entity, Float.valueOf(source.func_70032_d(entity)));
        }
        for (Map.Entry entry : CollectionUtil.sortMapByValueAsc(entities)) {
            closestEntities.add((Entity)entry.getKey());
            if (--maxAmount > 0) continue;
            break;
        }
        return closestEntities;
    }

    public static double[] getNormalizedVector(double vecX, double vecZ) {
        double[] dArray;
        double len = Math.sqrt(vecX * vecX + vecZ * vecZ);
        if (len == 0.0) {
            double[] dArray2 = new double[2];
            dArray2[0] = 0.0;
            dArray = dArray2;
            dArray2[1] = 0.0;
        } else {
            double[] dArray3 = new double[2];
            dArray3[0] = vecX / len;
            dArray = dArray3;
            dArray3[1] = vecZ / len;
        }
        return dArray;
    }

    public static Vec3 getRandomVector(Random rand) {
        return Vec3.func_72443_a((double)(rand.nextDouble() - 0.5), (double)(rand.nextDouble() - 0.5), (double)(rand.nextDouble() - 0.5)).func_72432_b();
    }

    public static <T> T[] getNonNullValues(T[] array) {
        if (array.length == 0) {
            return array;
        }
        int nonNull = 0;
        int cnt = 0;
        for (T t : array) {
            if (t == null) continue;
            ++nonNull;
        }
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), nonNull);
        for (T t : array) {
            if (t == null) continue;
            newArray[cnt++] = t;
        }
        return newArray;
    }

    public static int getTopBlockY(World world, Block block, int x, int z, int startY) {
        BlockPosM pos = new BlockPosM(x, startY, z);
        while (pos.y >= 0) {
            if (pos.getBlock((IBlockAccess)world) == block) {
                return pos.y;
            }
            --pos.y;
        }
        return -1;
    }

    public static int getTopBlockY(World world, Block block, int x, int z) {
        return DragonUtil.getTopBlockY(world, block, x, z, 255);
    }

    public static void spawnXP(Entity entity, int amount) {
        int a = amount;
        while (a > 0) {
            int split = EntityXPOrb.func_70527_a((int)a);
            entity.field_70170_p.func_72838_d((Entity)new EntityXPOrb(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, a -= split));
        }
    }

    public static void teleportToOverworld(EntityPlayerMP player) {
        player.field_71133_b.func_71203_ab().func_72356_a(player, 0);
        player.field_71135_a.field_147369_b = player.field_71133_b.func_71203_ab().func_72368_a(player, 0, true);
    }

    public static void createMobExplosion(Entity entity, double x, double y, double z, float strength, boolean fire) {
        entity.field_70170_p.func_72885_a(entity, x, y, z, strength, fire, entity.field_70170_p.func_82736_K().func_82766_b("mobGriefing"));
    }

    public static void createMobExplosion(World world, double x, double y, double z, float strength, boolean fire) {
        world.func_72885_a(null, x, y, z, strength, fire, world.func_82736_K().func_82766_b("mobGriefing"));
    }

    public static String stripChatFormatting(String str) {
        return regexChatFormatting.matcher(str).replaceAll("");
    }

    public static int tryParse(String str, int def) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static int getDayDifference(Calendar cal1, Calendar cal2) {
        return MathUtil.floor((double)Math.abs(cal1.getTimeInMillis() - cal2.getTimeInMillis()) / 8.64E7);
    }

    public static boolean canAddOneItemTo(ItemStack is, ItemStack itemToAdd) {
        return is.func_77985_e() && is.func_77973_b() == itemToAdd.func_77973_b() && (!is.func_77981_g() || is.func_77960_j() == itemToAdd.func_77960_j()) && ItemStack.func_77970_a((ItemStack)is, (ItemStack)itemToAdd) && is.field_77994_a + 1 <= is.func_77976_d();
    }

    public static boolean checkSystemProperty(String key) {
        String str = System.getProperty("hee");
        return str != null && ArrayUtils.contains((Object[])str.split(","), (Object)key);
    }

    private DragonUtil() {
    }

    static {
        formatOnePlace = new DecimalFormat("0.0");
        formatTwoPlaces = new DecimalFormat("0.00");
        regexChatFormatting = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-OR]");
        rayX = new double[]{-1.0, -1.0, 1.0, 1.0};
        rayZ = new double[]{-1.0, 1.0, -1.0, 1.0};
    }
}

