/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import com.google.common.collect.Maps;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Map;
import net.blay09.mods.craftingtweaks.CommonProxy;
import net.blay09.mods.craftingtweaks.Compatiblity;
import net.blay09.mods.craftingtweaks.GuiClickEvent;
import net.blay09.mods.craftingtweaks.InternalMethodsImpl;
import net.blay09.mods.craftingtweaks.SimpleTweakProviderImpl;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.api.TweakProvider;
import net.blay09.mods.craftingtweaks.net.NetworkHandler;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;

@Mod(modid="craftingtweaks", name="Gregory Tweaks For Crafting", version="1.2.64-GTNH", acceptableRemoteVersions="*")
public class CraftingTweaks {
    public static final Logger logger = LogManager.getLogger();
    public static final String MOD_ID = "craftingtweaks";
    public static CraftingTweaks instance;
    @SidedProxy(clientSide="net.blay09.mods.craftingtweaks.client.ClientProxy", serverSide="net.blay09.mods.craftingtweaks.CommonProxy")
    public static CommonProxy proxy;
    public static boolean isServerSideInstalled;
    private static Configuration config;
    private final Map<String, ModSupportState> configMap = Maps.newHashMap();
    private final Map<Class<? extends Container>, TweakProvider> providerMap = Maps.newHashMap();
    public static boolean hideButtons;
    public static boolean compressAnywhere;
    public static boolean hideButtonTooltips;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        instance = this;
        CraftingTweaksAPI.setupAPI(new InternalMethodsImpl());
        this.configMap.put("minecraft", ModSupportState.ENABLED);
        this.configMap.put("TConstruct", ModSupportState.ENABLED);
        this.configMap.put("appliedenergistics2", ModSupportState.BUTTONS_ONLY);
        this.configMap.put("DraconicEvolution", ModSupportState.ENABLED);
        this.configMap.put("Natura", ModSupportState.ENABLED);
        this.configMap.put("Thaumcraft", ModSupportState.ENABLED);
        this.configMap.put("MineFactoryReloaded", ModSupportState.ENABLED);
        this.configMap.put("Forestry", ModSupportState.ENABLED);
        this.configMap.put("Railcraft", ModSupportState.ENABLED);
        this.configMap.put("BuildCraft|Factory", ModSupportState.ENABLED);
        this.configMap.put("RotaryCraft", ModSupportState.ENABLED);
        this.configMap.put("RotaryCraft", ModSupportState.ENABLED);
        this.configMap.put("TwilightForest", ModSupportState.ENABLED);
        this.configMap.put("terrafirmacraft", ModSupportState.ENABLED);
        this.configMap.put("ganyssurface", ModSupportState.ENABLED);
        this.configMap.put("jacb", ModSupportState.ENABLED);
        this.configMap.put("bluepower", ModSupportState.ENABLED);
        this.configMap.put("BiblioCraft", ModSupportState.ENABLED);
        this.configMap.put("ThermalExpansion", ModSupportState.ENABLED);
        this.configMap.put("Backpack", ModSupportState.ENABLED);
        config = new Configuration(event.getSuggestedConfigurationFile());
        hideButtons = config.getBoolean("hideButtons", "general", false, "This option is toggled by the 'Toggle Buttons' key that can be defined in the Controls settings.");
        hideButtonTooltips = config.getBoolean("hideButtonTooltips", "general", false, "Set this to true if you don't want the tweak buttons' tooltips to show.");
        compressAnywhere = config.getBoolean("compressAnywhere", "general", false, "Set this to true if you want the (de)compress feature to work outside of crafting GUIs (only works if installed on server)");
        config.setCategoryComment("addons", "Here you can control whether support for a mod should be enabled, buttons_only, hotkeys_only or disabled. For Vanilla Minecraft, see the option 'minecraft'. Mods are identified by their mod ids.");
        config.getString("minecraft", "addons", ModSupportState.ENABLED.name().toLowerCase(), "", ModSupportState.getValidValues());
        for (Property property : config.getCategory("addons").values()) {
            this.configMap.put(property.getName(), ModSupportState.fromName(config.getString(property.getName(), "addons", ModSupportState.ENABLED.name().toLowerCase(), "enabled, buttons_only, hotkeys_only or disabled", ModSupportState.getValidValues())));
        }
    }

    @Mod.EventHandler
    public void imc(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage message : event.getMessages()) {
            if (message.isNBTMessage() && message.key.equals("RegisterProvider")) {
                NBTTagCompound tagCompound = message.getNBTValue();
                String containerClassName = tagCompound.func_74779_i("ContainerClass");
                SimpleTweakProviderImpl provider = new SimpleTweakProviderImpl(message.getSender());
                int buttonOffsetX = tagCompound.func_74764_b("ButtonOffsetX") ? tagCompound.func_74762_e("ButtonOffsetX") : -16;
                int buttonOffsetY = tagCompound.func_74764_b("ButtonOffsetY") ? tagCompound.func_74762_e("ButtonOffsetY") : 16;
                EnumFacing alignToGrid = null;
                String alignToGridName = tagCompound.func_74779_i("AlignToGrid");
                switch (alignToGridName.toLowerCase()) {
                    case "north": 
                    case "up": {
                        alignToGrid = EnumFacing.UP;
                        break;
                    }
                    case "south": 
                    case "down": {
                        alignToGrid = EnumFacing.DOWN;
                        break;
                    }
                    case "east": 
                    case "right": {
                        alignToGrid = EnumFacing.EAST;
                        break;
                    }
                    case "west": 
                    case "left": {
                        alignToGrid = EnumFacing.WEST;
                    }
                }
                provider.setAlignToGrid(alignToGrid);
                provider.setGrid(CraftingTweaks.getIntOr(tagCompound, "GridSlotNumber", 1), CraftingTweaks.getIntOr(tagCompound, "GridSize", 9));
                provider.setHideButtons(tagCompound.func_74767_n("HideButtons"));
                provider.setPhantomItems(tagCompound.func_74767_n("PhantomItems"));
                NBTTagCompound rotateCompound = tagCompound.func_74775_l("TweakRotate");
                provider.setTweakRotate(CraftingTweaks.getBoolOr(rotateCompound, "Enabled", true), CraftingTweaks.getBoolOr(rotateCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(rotateCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(rotateCompound, "ButtonY", 0));
                NBTTagCompound balanceCompound = tagCompound.func_74775_l("TweakBalance");
                provider.setTweakBalance(CraftingTweaks.getBoolOr(balanceCompound, "Enabled", true), CraftingTweaks.getBoolOr(balanceCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(balanceCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(balanceCompound, "ButtonY", 18));
                NBTTagCompound clearCompound = tagCompound.func_74775_l("TweakClear");
                provider.setTweakClear(CraftingTweaks.getBoolOr(clearCompound, "Enabled", true), CraftingTweaks.getBoolOr(clearCompound, "ShowButton", true), buttonOffsetX + CraftingTweaks.getIntOr(clearCompound, "ButtonX", 0), buttonOffsetY + CraftingTweaks.getIntOr(clearCompound, "ButtonY", 36));
                this.registerProvider(containerClassName, (TweakProvider)provider);
                logger.info(message.getSender() + " has registered " + containerClassName + " for CraftingTweaks");
                continue;
            }
            logger.warn("CraftingTweaks received an invalid IMC message from " + message.getSender());
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        NetworkHandler.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        this.configMap.put("appliedenergistics2", ModSupportState.BUTTONS_ONLY);
        Compatiblity.vanilla();
        Compatiblity.appliedenergistics2();
        Compatiblity.avaritia();
        Compatiblity.backpacks();
        Compatiblity.bibliocraft();
        Compatiblity.bluepower();
        Compatiblity.buildcraft();
        Compatiblity.jacb();
        Compatiblity.ganyssurface();
        Compatiblity.forestry();
        Compatiblity.draconicevolution();
        Compatiblity.natura();
        Compatiblity.minefactoryreloaded();
        Compatiblity.twilightforest();
        Compatiblity.tinkersconstruct();
        Compatiblity.thermalexpansion();
        Compatiblity.railcraft();
        Compatiblity.thaumcraft4();
        Compatiblity.rotarycraft();
        Compatiblity.terrafirmacraft();
        config.save();
    }

    @NetworkCheckHandler
    public boolean checkNetwork(Map<String, String> map, Side side) {
        if (side == Side.SERVER) {
            isServerSideInstalled = map.containsKey(MOD_ID);
        }
        return true;
    }

    public void registerProvider(Class<? extends Container> clazz, TweakProvider provider) {
        if (!provider.getModId().equals("minecraft") && !Loader.isModLoaded((String)provider.getModId())) {
            return;
        }
        if (provider.load()) {
            this.providerMap.put(clazz, provider);
        }
    }

    public void registerProvider(String className, TweakProvider provider) {
        config.getString(provider.getModId(), "addons", ModSupportState.ENABLED.name().toLowerCase(), "enabled, buttons_only, hotkeys_only or disabled", ModSupportState.getValidValues());
        if (Loader.isModLoaded((String)provider.getModId()) && provider.load()) {
            try {
                Class<?> clazz = Class.forName(className);
                if (Container.class.isAssignableFrom(clazz)) {
                    this.providerMap.put(clazz, provider);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public TweakProvider getProvider(Container container) {
        if (container == null) {
            return null;
        }
        for (Class<? extends Container> clazz : this.providerMap.keySet()) {
            if (container.getClass() != clazz) continue;
            return this.providerMap.get(clazz);
        }
        for (Class<? extends Container> clazz : this.providerMap.keySet()) {
            if (!clazz.isAssignableFrom(container.getClass())) continue;
            return this.providerMap.get(clazz);
        }
        return null;
    }

    public ModSupportState getModSupportState(String modId) {
        ModSupportState suportState = this.configMap.get(modId);
        if (suportState == null) {
            suportState = ModSupportState.ENABLED;
            this.configMap.put(modId, suportState);
        }
        return suportState;
    }

    public static void saveConfig() {
        config.get("general", "hideButtons", false, "This option is toggled by the 'Toggle Buttons' key that can be defined in the Controls settings.").set(hideButtons);
        config.save();
    }

    private static int getIntOr(NBTTagCompound tagCompound, String key, int defaultVal) {
        return tagCompound.func_74764_b(key) ? tagCompound.func_74762_e(key) : defaultVal;
    }

    private static boolean getBoolOr(NBTTagCompound tagCompound, String key, boolean defaultVal) {
        return tagCompound.func_74764_b(key) ? tagCompound.func_74767_n(key) : defaultVal;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean onGuiClick(int mouseX, int mouseY, int button) {
        if (Mouse.getEventButtonState()) {
            GuiClickEvent event = new GuiClickEvent(FMLClientHandler.instance().getClient().field_71462_r, mouseX, mouseY, button);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.isCanceled();
        }
        return false;
    }

    static {
        isServerSideInstalled = false;
    }

    public static enum ModSupportState {
        ENABLED,
        BUTTONS_ONLY,
        HOTKEYS_ONLY,
        DISABLED;


        public static ModSupportState fromName(String name) {
            try {
                return ModSupportState.valueOf(name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return ENABLED;
            }
        }

        public static String[] getValidValues() {
            ModSupportState[] values = ModSupportState.values();
            String[] validValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                validValues[i] = values[i].name().toLowerCase();
            }
            return validValues;
        }
    }
}

