/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak;

import com.google.common.collect.ImmutableList;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import gnu.trove.map.TObjectDoubleMap;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.glease.tc4tweak.CommonUtils;
import net.glease.tc4tweak.ConfigurationVersion;
import net.glease.tc4tweak.TC4Tweak;
import net.glease.tc4tweak.config.StringOrderingEntry;
import net.glease.tc4tweak.modules.FlushableCache;
import net.glease.tc4tweak.modules.infusionRecipe.InfusionOreDictMode;
import net.glease.tc4tweak.modules.infusionRecipe.InfusionRecipeGetOutput;
import net.glease.tc4tweak.modules.researchBrowser.BrowserPaging;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public enum ConfigurationHandler {
    INSTANCE;

    private Configuration config;
    private boolean inverted;
    private int updateInterval;
    private boolean checkWorkbenchRecipes;
    private int arcaneCraftingHistorySize;
    private boolean addTooltip;
    private boolean mappingThreadNice;
    private float browserScale;
    private boolean limitBookSearchToCategory;
    private float nodeVisualSizeLimit;
    private boolean inferBrowserScale;
    private float inferBrowserScaleUpperBound;
    private float inferBrowserScaleLowerBound;
    private boolean inferBrowserScaleConsiderSearch;
    private boolean smallerJars;
    private boolean moreRandomizedLoot;
    private boolean dispenserShootPrimalArrow;
    private boolean addClearButton;
    private boolean addResearchSearch;
    private int decantMaxBlocks;
    private boolean savedLinkSaveWholeLink;
    private boolean savedLink;
    private boolean savedLinkDebug;
    private boolean alternativeAddStack;
    private boolean sendSupplementaryS35;
    private boolean infusionRecipeNBTModifyArmorToolOnly;
    private boolean infusionRecipeNBTCarryOver;
    private List<String> infusionRecipeNBTWhitelist = new ArrayList<String>();
    private int browserHeight = 230;
    private int browserWidth = 256;
    private InfusionOreDictMode infusionOreDictMode = InfusionOreDictMode.Default;
    private List<String> categoryOrder = new ArrayList<String>();
    private CompletionCounterStyle counterStyle = CompletionCounterStyle.Current;
    private EarthShockHarmMode earthShockHarmMode = EarthShockHarmMode.OnlyLiving;
    private final TObjectDoubleMap<UUID> championMods = new TObjectDoubleHashMap();

    private ConfigurationHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    void init(File f) {
        this.config = new Configuration(f, ConfigurationVersion.latest().getVersionMarker());
        ConfigurationVersion.migrateToLatest(this.config);
        this.loadConfig(false);
        this.setLanguageKeys();
    }

    private void breakLongCommentLines() {
        for (String categoryName : this.config.getCategoryNames()) {
            ConfigCategory category = this.config.getCategory(categoryName);
            for (Map.Entry entry : category.entrySet()) {
                ((Property)entry.getValue()).comment = ((Property)entry.getValue()).comment.replace(". ", ".\n");
            }
        }
    }

    private void setLanguageKeys() {
        for (String categoryName : this.config.getCategoryNames()) {
            ConfigCategory category = this.config.getCategory(categoryName);
            category.setLanguageKey("tc4tweaks.config." + categoryName);
            for (Map.Entry entry : category.entrySet()) {
                ((Property)entry.getValue()).setLanguageKey(String.format("%s.%s", category.getLanguagekey(), entry.getKey()));
            }
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (e.modID.equals("tc4tweak")) {
            this.loadConfig(true);
            FlushableCache.enableAll(false);
            CommonUtils.sortResearchCategories(true);
        }
    }

    private void loadConfig(boolean send) {
        this.checkWorkbenchRecipes = this.config.getBoolean("checkWorkbenchRecipes", "general", true, "When false, Arcane Workbench will not perform vanilla crafting bench recipes. Arcane Workbench GUI will behave slightly awkwardly if the client has it false but not on server, but nothing would be broken.");
        this.arcaneCraftingHistorySize = this.config.getInt("arcaneCraftingHistorySize", "general", 16, 0, 256, "The maximum size of arcane crafting cache. 0 will effectively turn off the cache. It is suggested to keep a size of at least 1 to ensure shift crafting does not lag the server.");
        this.inverted = this.config.getBoolean("inverted", "client", false, "Flip it if you find the scrolling unintuitive");
        this.updateInterval = this.config.getInt("updateInterval", "client", 4, 0, 40, "How often should Arcane Workbench update displayed crafting result. Unit is in game ticks.");
        this.addTooltip = this.config.getBoolean("addTooltip", "client", true, "If false, no tooltip will be added.");
        int mappingThreadNiceType = this.config.getInt("mappingThreadNiceType", "client", 0, 0, 2, "Whether to adjust mapping thread priority. 0 means auto. 1 means force enable. 2 means force disable.");
        switch (mappingThreadNiceType) {
            case 1: {
                this.mappingThreadNice = true;
                break;
            }
            case 2: {
                this.mappingThreadNice = false;
                break;
            }
            default: {
                this.mappingThreadNice = Runtime.getRuntime().availableProcessors() < 3;
            }
        }
        this.browserScale = this.config.getFloat("scale", "client.browser_scale", 1.0f, 1.0f, 4.0f, "Tweak the size of the book gui. No longer works if inferBrowserScale is set to true.");
        this.limitBookSearchToCategory = this.config.getBoolean("limitBookSearchToCategory", "client", false, "Whether the book gui search should search current tab only.");
        this.nodeVisualSizeLimit = this.config.getFloat("limitOversizedNodeRender", "client", 1.0f, 0.5f, 1.0E10f, "The upper limit on how big nodes can be rendered. This is purely a visual thing and will not affect how big your node can actually grow. Setting a value like 10000.0 will effectively turn off this functionality, i.e. not limit the rendered size.");
        this.inferBrowserScale = this.config.getBoolean("infer", "client.browser_scale", true, "Tweak the size of the book gui based on screen size automatically. The value of browserScale set manually will not function any more.");
        this.inferBrowserScaleUpperBound = this.config.getFloat("maximum", "client.browser_scale", 4.0f, 1.0f, 16.0f, "The minimum inferred scale. Cannot be smaller than the value of inferBrowserScaleLowerBound. This shouldn't be too high as a huge browser would be rendered with really poor image quality.");
        this.inferBrowserScaleLowerBound = this.config.getFloat("minimum", "client.browser_scale", 1.0f, 1.0f, 16.0f, "The maximum inferred scale. Cannot be bigger than the value of inferBrowserScaleUpperBound.");
        this.inferBrowserScaleConsiderSearch = this.config.getBoolean("considerSearchArea", "client.browser_scale", true, "The search result area, even if it's not disabled, will be considered while inferring browserScale.");
        this.smallerJars = this.config.getBoolean("smallerJars", "general", FMLLaunchHandler.side().isServer(), "If true, jars (brain in jar, essentia jars, etc) will have a collision box the same as block outline. Otherwise it will have a collision box of 1x1x1, which is the vanilla tc4 behavior.");
        this.moreRandomizedLoot = this.config.getBoolean("moreRandomizedLoot", "general", true, "If true, enchanted books will have randomized enchantment and vis stone will have different vis stored even without server restart.");
        this.infusionOreDictMode = InfusionOreDictMode.get(this.config.getString("oreDictMode", "general.infusion_recipes", this.infusionOreDictMode.name(), "Select the infusion oredict mode. Default: vanilla TC4 behavior. Strict: all oredict names must match to count as oredict substitute. Relaxed: oredict names needs only overlaps to count as oredict substitute. None: no oredict substitute at all.", (String[])Arrays.stream(InfusionOreDictMode.values()).map(Enum::name).toArray(String[]::new)));
        this.categoryOrder = ImmutableList.copyOf((Object[])this.config.getStringList("categoryOrder", "client", new String[]{"BASICS", "THAUMATURGY", "ALCHEMY", "ARTIFICE", "GOLEMANCY", "ELDRITCH"}, "Specify a full sorting order of research tabs. An empty list here means the feature is disabled. any research tab not listed here will be appended to the end in their original order. Use NEI utility to dump a list of all research tabs. Default is the list of all vanilla thaumcraft tabs."));
        this.dispenserShootPrimalArrow = this.config.getBoolean("dispenserShootPrimalArrow", "general", false, "If true, dispenser will shoot primal arrow instead of dropping it into world.");
        this.addClearButton = this.config.getBoolean("addClearButton", "client", true, "If true, a button will be shown when there is any amount of tc4 notifications AND when sending chat.");
        this.addResearchSearch = this.config.getBoolean("addResearchSearch", "client", true, "If true, a search box will appear on the top right bar of thaumonomicon gui. This feature is taken from WitchingGadgets due to the said GUI is being upsized by this mod and without modifying its code, the search box would not be positioned correctly. Will disable WitchingGadget's search feature (if it is present) regardless of whether this is true.");
        this.counterStyle = CompletionCounterStyle.get(this.config.getString("completionCounterStyle", "client", this.counterStyle.name(), "Select the style of completion counter. None: disable completion progress counter. Current: display how many you have completed already, and only show the total count for this tab when everything here has been learnt. All: show all counters at all times.", (String[])Arrays.stream(CompletionCounterStyle.values()).map(Enum::name).toArray(String[]::new)));
        this.decantMaxBlocks = this.config.getInt("decantMaxBlocks", "general", 1000, 1, Integer.MAX_VALUE, "Max blocks in queue of decant golem. High values can lead to severe server lag if golem is marked to empty very large body of fluid and has very long visibility range");
        this.earthShockHarmMode = EarthShockHarmMode.get(this.config.getString("earthShockHarmMode", "general", this.earthShockHarmMode.name(), "Select the entities to be damaged by earth shock. Note: certain entity (e.g. most projectiles) cannot be damaged even if it's on the list. OnlyLiving: only harm living entities, e.g. cows, players, zombies, the most intuitive behavior. ExceptItemXp: harm everything except items and xp orbs, e.g. item frames, all living entities like mentioned before. AllEntity: harm everything, like thaumcraft does out of box", (String[])Arrays.stream(EarthShockHarmMode.values()).map(Enum::name).toArray(String[]::new)));
        this.savedLink = this.config.getBoolean("enable", "general.saved_link", true, "Enable this feature. When disabled, no additional data will be saved to disk");
        this.savedLinkSaveWholeLink = this.config.getBoolean("saveCompleteLink", "general.saved_link", false, "When enabled, save the entire link up to source node. There is no actual benefit of this beyond more debug info. You probably don't want to change this.");
        this.savedLinkDebug = this.config.getBoolean("debug", "general.saved_link", false, "When enabled, print more debug info for this feature. You probably don't want to change this.");
        this.alternativeAddStack = this.config.getBoolean("alternativeAddStack", "general", true, "When enabled, using a phial will cause the new stack to be added to current player inventory using an alternative rule that prefers partial stacks and current slot.");
        this.sendSupplementaryS35 = this.config.getBoolean("sendSupplementaryS35", "general", true, "When enabled, will try harder at sending server side states for some particular tile entities. Enabling this might leads to very slight bandwidth usage increase, but can fix some rare desync.");
        this.infusionRecipeNBTCarryOver = this.config.getBoolean("enable", "general.infusion_recipes.nbtcarryover", true, "Set to true to enable this feature. Typically, this would carry over enchantments and custom names, but can also carry over stuff like runic shielding");
        this.infusionRecipeNBTModifyArmorToolOnly = this.config.getBoolean("armorToolOnly", "general.infusion_recipes.nbtcarryover", true, "When enabled, will only affect inputs and outputs that are both armor/tools. If you need more custom behavior, then calling TC4Tweaks api via java or ZenScript would become necessary.");
        this.infusionRecipeNBTWhitelist = Arrays.asList(this.config.getStringList("carryOverWhitelist", "general.infusion_recipes.nbtcarryover", new String[0], "When not empty, will only carry over named NBT values."));
        String[][] championMods = new String[][]{{"a62bef38-48cc-42a6-ac5e-ef913841c4fd", "Champion health buff", "Champion health buff. Plain add."}, {"a340d2db-d881-4c25-ac62-f0ad14cd63b0", "Champion damage buff", "Champion damage buff. +x%, i.e. if configured as 1, the mob will deal double damage."}, {"4b1edd33-caa9-47ae-a702-d86c05701037", "Bold speed boost", "Bold speed boost. Multiplier, i.e. if configured as 2, the mob will have double speed."}, {"7163897f-07f5-49b3-9ce4-b74beb83d2d3", "Mighty damage boost", "Mighty damage boost. +x%, i.e. if configured as 1, the mob will deal double damage."}, {"54d621c1-dd4d-4b43-8bd2-5531c8875797", "HEALTH BUFF 1", "Boss health buff when at least 1 player present when spawned. Plain add."}, {"f51257dc-b7fa-4f7a-92d7-75d68e8592c4", "HEALTH BUFF 2", "Boss health buff when at least 2 player present when spawned. Plain add."}, {"3d6b2e42-4141-4364-b76d-0e8664bbd0bb", "HEALTH BUFF 3", "Boss health buff when at least 3 player present when spawned. Plain add."}, {"02c97a08-801c-4131-afa2-1427a6151934", "HEALTH BUFF 4", "Boss health buff when at least 4 player present when spawned. Plain add."}, {"0f354f6a-33c5-40be-93be-81b1338567f1", "HEALTH BUFF 5", "Boss health buff when at least 5 player present when spawned. Plain add."}, {"534f8c57-929a-48cf-bbd6-0fd851030748", "DAMAGE BUFF 1", "Boss damage buff when at least 1 player present when spawned. Plain add."}, {"d317a76e-0e7c-4c61-acfd-9fa286053b32", "DAMAGE BUFF 2", "Boss damage buff when at least 2 player present when spawned. Plain add."}, {"ff462d63-26a2-4363-830e-143ed97e2a4f", "DAMAGE BUFF 3", "Boss damage buff when at least 3 player present when spawned. Plain add."}, {"cf1eb39e-0c67-495f-887c-0d3080828d2f", "DAMAGE BUFF 4", "Boss damage buff when at least 4 player present when spawned. Plain add."}, {"3cfab9da-2701-43d8-ac07-885f16fa4117", "DAMAGE BUFF 5", "Boss damage buff when at least 5 player present when spawned. Plain add."}};
        double[] defaults = new double[]{30.0, 2.0, 0.3, 3.0, 50.0, 50.0, 50.0, 50.0, 50.0, 0.5, 0.5, 0.5, 0.5, 0.5};
        for (int i = 0; i < championMods.length; ++i) {
            Property p = this.config.get("general.champion_mods", championMods[i][1], defaults[i], championMods[i][2]);
            p.setMinValue(0.0);
            this.championMods.put((Object)UUID.fromString(championMods[i][0]), p.getDouble());
        }
        this.config.getCategory("general.champion_mods").setComment("Tweak the stat buffs applied to champion mobs. Do note that those boss buffs can stack. If 5 player is present then all of DAMAGE BUFF 1 to DAMAGE BUFF 5 will be applied!");
        this.config.getCategory("general.saved_link").setComment("Persist the parents of vis relays into save file and use it as a hint when it is loaded back to memory.");
        this.config.getCategory("general.infusion_recipes").setComment("Tweak how TC4Tweaks changes the behavior of infusion recipes.");
        this.config.getCategory("general.infusion_recipes.nbtcarryover").setComment("Tweak how TC4Tweaks make NBT tags present on center item to be carried over to output item.");
        if (this.inferBrowserScaleLowerBound > this.inferBrowserScaleUpperBound) {
            this.config.getCategory("client").get("inferBrowserScaleLowerBound").set((double)this.inferBrowserScaleUpperBound);
        }
        this.browserWidth = (int)(this.browserScale * 256.0f);
        this.browserHeight = (int)(this.browserScale * 230.0f);
        TC4Tweak.INSTANCE.setAllowAll(true);
        InfusionRecipeGetOutput.reload();
        if (send) {
            TC4Tweak.INSTANCE.detectAndSendConfigChanges();
            BrowserPaging.flushCache();
        }
        this.breakLongCommentLines();
        this.config.save();
    }

    void setGUISettings() {
        this.config.getCategory("client").get("categoryOrder").setArrayEntryClass(StringOrderingEntry.class);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean isCheckWorkbenchRecipes() {
        return this.checkWorkbenchRecipes;
    }

    public int getArcaneCraftingHistorySize() {
        return this.arcaneCraftingHistorySize;
    }

    public boolean isAddTooltip() {
        return this.addTooltip;
    }

    public boolean isMappingThreadNice() {
        return this.mappingThreadNice;
    }

    public float getBrowserScale() {
        return this.browserScale;
    }

    public void setBrowserScale(float browserScale) {
        this.browserScale = Math.max(Math.min(browserScale, this.inferBrowserScaleUpperBound), this.inferBrowserScaleLowerBound);
        this.browserWidth = (int)(browserScale * 256.0f);
        this.browserHeight = (int)(browserScale * 230.0f);
    }

    public int getBrowserHeight() {
        return this.browserHeight;
    }

    public int getBrowserWidth() {
        return this.browserWidth;
    }

    public boolean isLimitBookSearchToCategory() {
        return this.limitBookSearchToCategory;
    }

    public float getNodeVisualSizeLimit() {
        return this.nodeVisualSizeLimit;
    }

    public boolean isInferBrowserScale() {
        return this.inferBrowserScale;
    }

    public boolean isInferBrowserScaleConsiderSearch() {
        return this.inferBrowserScaleConsiderSearch;
    }

    public boolean isSmallerJars() {
        return this.smallerJars;
    }

    public boolean isMoreRandomizedLoot() {
        return this.moreRandomizedLoot;
    }

    public boolean isDispenserShootPrimalArrow() {
        return this.dispenserShootPrimalArrow;
    }

    public InfusionOreDictMode getInfusionOreDictMode() {
        return this.infusionOreDictMode;
    }

    public List<String> getCategoryOrder() {
        return this.categoryOrder;
    }

    public boolean isAddClearButton() {
        return this.addClearButton;
    }

    public boolean isAddResearchSearch() {
        return this.addResearchSearch;
    }

    public CompletionCounterStyle getResearchCounterStyle() {
        return this.counterStyle;
    }

    public double getChampionModValue(UUID configKey, double old) {
        double v = this.championMods.get((Object)configKey);
        if (v == this.championMods.getNoEntryValue()) {
            return old;
        }
        return v;
    }

    public int getDecantMaxBlocks() {
        return this.decantMaxBlocks;
    }

    public EarthShockHarmMode getEarthShockHarmMode() {
        return this.earthShockHarmMode;
    }

    public boolean isSavedLinkSaveWholeLink() {
        return this.savedLinkSaveWholeLink;
    }

    public boolean isSavedLinkEnabled() {
        return this.savedLink;
    }

    public boolean isSavedLinkDebugEnabled() {
        return this.savedLinkDebug;
    }

    public boolean isAlternativeAddStack() {
        return this.alternativeAddStack;
    }

    public boolean isSendSupplementaryS35() {
        return this.sendSupplementaryS35;
    }

    public List<String> getInfusionRecipeNBTWhitelist() {
        return this.infusionRecipeNBTWhitelist;
    }

    public boolean isInfusionRecipeNBTModifyArmorToolOnly() {
        return this.infusionRecipeNBTModifyArmorToolOnly;
    }

    public boolean isInfusionRecipeNBTCarryOver() {
        return this.infusionRecipeNBTCarryOver;
    }

    public static enum EarthShockHarmMode {
        OnlyLiving,
        ExceptItemXp,
        AllEntity;


        public static EarthShockHarmMode get(String name) {
            for (EarthShockHarmMode value : EarthShockHarmMode.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return OnlyLiving;
        }
    }

    public static enum CompletionCounterStyle {
        None,
        Current,
        All;


        public static CompletionCounterStyle get(String name) {
            for (CompletionCounterStyle value : CompletionCounterStyle.values()) {
                if (!value.name().equals(name)) continue;
                return value;
            }
            return Current;
        }
    }
}

