/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.blocks;

import biomesoplenty.BiomesOPlenty;
import biomesoplenty.client.render.RenderUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBamboo
extends Block
implements IPlantable {
    private IIcon bambooSide;
    private IIcon bambooTop;

    public BlockBamboo() {
        super(Material.field_151585_k);
        this.func_149711_c(0.2f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149675_a(true);
        this.func_149647_a(BiomesOPlenty.tabBiomesOPlenty);
    }

    public void func_149651_a(IIconRegister iconRegister) {
        this.bambooSide = iconRegister.func_94245_a("biomesoplenty:bamboo");
        this.bambooTop = iconRegister.func_94245_a("biomesoplenty:bambootop");
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side > 1) {
            return this.bambooSide;
        }
        return this.bambooTop;
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return this.getBoundingBox(world, x, y, z);
    }

    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        return this.getBoundingBox(world, x, y, z);
    }

    private AxisAlignedBB getBoundingBox(World world, int x, int y, int z) {
        float pixel = 0.0625f;
        return AxisAlignedBB.func_72330_a((double)((float)x + pixel * 4.0f), (double)y, (double)((float)z + pixel * 4.0f), (double)((float)(x + 1) - pixel * 4.0f), (double)(y + 1), (double)((float)(z + 1) - pixel * 4.0f));
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (world.func_147437_c(x, y + 1, z)) {
            int var6 = 1;
            while (world.func_147439_a(x, y - var6, z) == this) {
                ++var6;
            }
            if (var6 < 3) {
                int var7 = world.func_72805_g(x, y, z);
                if (var7 == 15) {
                    world.func_147465_d(x, y + 1, z, (Block)this, 0, 2);
                    world.func_72921_c(x, y, z, 0, 2);
                } else {
                    world.func_72921_c(x, y, z, var7 + 1, 2);
                }
            }
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        this.checkBlockCoordValid(world, x, y, z);
    }

    public final void checkBlockCoordValid(World world, int x, int y, int z) {
        if (!this.func_149718_j(world, x, y, z)) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
        }
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        return super.func_149742_c(world, x, y, z) && this.func_149718_j(world, x, y, z);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        Block bottomBlock = world.func_147439_a(x, y - 1, z);
        return bottomBlock.canSustainPlant((IBlockAccess)world, x, y - 1, z, ForgeDirection.UP, (IPlantable)this) || bottomBlock == this;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return RenderUtils.bambooModel;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean canSustainLeaves(IBlockAccess world, int x, int y, int z) {
        return true;
    }

    public EnumPlantType getPlantType(IBlockAccess world, int x, int y, int z) {
        return EnumPlantType.Plains;
    }

    public Block getPlant(IBlockAccess world, int x, int y, int z) {
        return this;
    }

    public int getPlantMetadata(IBlockAccess world, int x, int y, int z) {
        return world.func_72805_g(x, y, z);
    }
}

