/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui;

import com.gtnewhorizons.angelica.glsm.GLStateManager;
import cpw.mods.fml.client.config.GuiUtils;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL14;

public final class GuiUtil {
    public static final ResourceLocation IRIS_WIDGETS_TEX = new ResourceLocation("iris", "textures/gui/widgets.png");
    private static final String ELLIPSIS = "...";

    private GuiUtil() {
    }

    private static Minecraft client() {
        return Minecraft.func_71410_x();
    }

    public static void bindIrisWidgetsTexture() {
        GuiUtil.client().func_110434_K().func_110577_a(IRIS_WIDGETS_TEX);
    }

    public static void drawButton(int x, int y, int width, int height, boolean hovered, boolean disabled) {
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        int vOffset = disabled ? 46 : (hovered ? 86 : 66);
        GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GLStateManager.enableBlend();
        GLStateManager.enableTexture();
        GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)0, (int)vOffset, (int)halfWidth, (int)halfHeight, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(x + halfWidth), (int)y, (int)(200 - (width - halfWidth)), (int)vOffset, (int)(width - halfWidth), (int)halfHeight, (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)x, (int)(y + halfHeight), (int)0, (int)(vOffset + (20 - (height - halfHeight))), (int)halfWidth, (int)(height - halfHeight), (float)0.0f);
        GuiUtils.drawTexturedModalRect((int)(x + halfWidth), (int)(y + halfHeight), (int)(200 - (width - halfWidth)), (int)(vOffset + (20 - (height - halfHeight))), (int)(width - halfWidth), (int)(height - halfHeight), (float)0.0f);
    }

    public static void drawPanel(int x, int y, int width, int height) {
        int borderColor = -555819298;
        int innerColor = -570425344;
        Gui.func_73734_a((int)x, (int)y, (int)(x + width), (int)(y + 1), (int)-555819298);
        Gui.func_73734_a((int)x, (int)(y + height - 1), (int)(x + width), (int)(y + height), (int)-555819298);
        Gui.func_73734_a((int)x, (int)(y + 1), (int)(x + 1), (int)(y + height - 1), (int)-555819298);
        Gui.func_73734_a((int)(x + width - 1), (int)(y + 1), (int)(x + width), (int)(y + height - 1), (int)-555819298);
        Gui.func_73734_a((int)(x + 1), (int)(y + 1), (int)(x + width - 1), (int)(y + height - 1), (int)-570425344);
    }

    public static void drawTextPanel(FontRenderer font, String text, int x, int y) {
        GuiUtil.drawPanel(x, y, font.func_78256_a(text) + 8, 16);
        font.func_78261_a(text, x + 4, y + 4, 0xFFFFFF);
    }

    public static String shortenText(FontRenderer font, String text, int width) {
        if (font.func_78256_a(text) > width) {
            return font.func_78269_a(text, width - font.func_78256_a(ELLIPSIS)) + ELLIPSIS;
        }
        return text;
    }

    public static String translateOrDefault(String defaultText, String translationDesc, Object ... format) {
        String translated = I18n.func_135052_a((String)translationDesc, (Object[])format);
        if (!translated.equals(translationDesc)) {
            return translated;
        }
        return defaultText;
    }

    public static void playButtonClickSound() {
    }

    public static class Icon {
        public static final Icon SEARCH = new Icon(0, 0, 7, 8);
        public static final Icon CLOSE = new Icon(7, 0, 5, 6);
        public static final Icon REFRESH = new Icon(12, 0, 10, 10);
        public static final Icon EXPORT = new Icon(22, 0, 7, 8);
        public static final Icon EXPORT_COLORED = new Icon(29, 0, 7, 8);
        public static final Icon IMPORT = new Icon(22, 8, 7, 8);
        public static final Icon IMPORT_COLORED = new Icon(29, 8, 7, 8);
        private final int u;
        private final int v;
        private final int width;
        private final int height;

        public Icon(int u, int v, int width, int height) {
            this.u = u;
            this.v = v;
            this.width = width;
            this.height = height;
        }

        public void draw(int x, int y) {
            GL14.glBlendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GLStateManager.enableBlend();
            GLStateManager.enableTexture();
            GuiUtils.drawTexturedModalRect((int)x, (int)y, (int)this.u, (int)this.v, (int)this.width, (int)this.height, (float)256.0f);
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }
    }
}

