/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.tracks.locking;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.common.blocks.tracks.TrackNextGenLocking;
import mods.railcraft.common.blocks.tracks.locking.LockingProfile;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTTagCompound;

public class HoldingLockingProfile
extends LockingProfile {
    protected static float DIR_THRESHOLD = 0.01f;
    protected boolean launchForward = true;

    public HoldingLockingProfile(TrackNextGenLocking track) {
        super(track);
    }

    @Override
    public void onLock(EntityMinecart cart) {
        super.onLock(cart);
        this.setLaunchDirection(cart);
    }

    @Override
    public void onRelease(EntityMinecart cart) {
        super.onRelease(cart);
        int meta = this.track.tileEntity.func_145832_p();
        double speed = CartTools.getCartSpeedUncapped(cart);
        double boostX = TrackNextGenLocking.START_BOOST;
        double boostZ = TrackNextGenLocking.START_BOOST;
        if (speed > 0.005) {
            boostX = Math.abs(cart.field_70159_w) / speed * TrackNextGenLocking.BOOST_FACTOR;
            boostZ = Math.abs(cart.field_70179_y) / speed * TrackNextGenLocking.BOOST_FACTOR;
        }
        if (meta == 0 || meta == 4 || meta == 5) {
            cart.field_70179_y = this.launchForward ? (cart.field_70179_y += boostZ) : (cart.field_70179_y -= boostZ);
        } else if (meta == 1 || meta == 2 || meta == 3) {
            cart.field_70159_w = this.launchForward ? (cart.field_70159_w += boostX) : (cart.field_70159_w -= boostX);
        }
    }

    protected void setLaunchDirection(EntityMinecart cart) {
        int meta = this.track.tileEntity.func_145832_p();
        double speed = CartTools.getCartSpeedUncapped(cart);
        if (speed > (double)DIR_THRESHOLD) {
            boolean launch = this.launchForward;
            if (meta == 0 || meta == 4 || meta == 5) {
                launch = cart.field_70179_y > 0.0;
            } else if (meta == 1 || meta == 2 || meta == 3) {
                boolean bl = launch = cart.field_70159_w > 0.0;
            }
            if (this.launchForward != launch) {
                this.launchForward = launch;
                this.track.sendUpdateToClient();
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("launchForward", this.launchForward);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.launchForward = data.func_74767_n("launchForward");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.launchForward);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.launchForward = data.readBoolean();
        this.track.markBlockNeedsUpdate();
    }
}

