/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.alchemy.energy;

import WayofTime.alchemicalWizardry.api.alchemy.energy.IReagentHandler;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainerInfo;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileReagentHandler
extends TileEntity
implements IReagentHandler {
    protected ReagentContainer tank = new ReagentContainer(4000);

    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        ReagentContainer.readFromNBT(tag);
    }

    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        this.tank.writeToNBT(tag);
    }

    @Override
    public int fill(ForgeDirection from, ReagentStack resource, boolean doFill) {
        return this.tank.fill(resource, doFill);
    }

    @Override
    public ReagentStack drain(ForgeDirection from, ReagentStack resource, boolean doDrain) {
        if (resource == null || !resource.isReagentEqual(this.tank.getReagent())) {
            return null;
        }
        return this.tank.drain(resource.amount, doDrain);
    }

    @Override
    public ReagentStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.tank.drain(maxDrain, doDrain);
    }

    @Override
    public boolean canFill(ForgeDirection from, Reagent reagent) {
        return true;
    }

    @Override
    public boolean canDrain(ForgeDirection from, Reagent reagent) {
        return true;
    }

    @Override
    public ReagentContainerInfo[] getContainerInfo(ForgeDirection from) {
        return new ReagentContainerInfo[]{this.tank.getInfo()};
    }
}

