/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.items;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBloodOrb;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessBloodOrbRecipe
implements IRecipe {
    private ItemStack output = null;
    private ArrayList<Object> input = new ArrayList();

    public ShapelessBloodOrbRecipe(Block result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessBloodOrbRecipe(Item result, Object ... recipe) {
        this(new ItemStack(result), recipe);
    }

    public ShapelessBloodOrbRecipe(ItemStack result, Object ... recipe) {
        this.output = result.copy();
        for (Object in : recipe) {
            if (in instanceof IBloodOrb) {
                this.input.add(((IBloodOrb)in).getOrbLevel());
                continue;
            }
            if (in instanceof ItemStack) {
                if (((ItemStack)in).getItem() instanceof IBloodOrb) {
                    this.input.add(((IBloodOrb)((ItemStack)in).getItem()).getOrbLevel());
                    continue;
                }
                this.input.add(((ItemStack)in).copy());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                this.input.add(OreDictionary.getOres((String)((String)in)));
                continue;
            }
            String ret = "Invalid shapeless ore recipe: ";
            for (Object tmp : recipe) {
                ret = ret + tmp + ", ";
            }
            ret = ret + this.output;
            throw new RuntimeException(ret);
        }
    }

    ShapelessBloodOrbRecipe(ShapelessRecipes recipe, Map<ItemStack, String> replacements) {
        this.output = recipe.getRecipeOutput();
        Iterator i$ = recipe.recipeItems.iterator();
        while (i$.hasNext()) {
            ItemStack ingred;
            Object finalObj = ingred = (ItemStack)i$.next();
            for (Map.Entry<ItemStack, String> replace : replacements.entrySet()) {
                if (!OreDictionary.itemMatches((ItemStack)replace.getKey(), (ItemStack)ingred, (boolean)false)) continue;
                finalObj = OreDictionary.getOres((String)replace.getValue());
                break;
            }
            this.input.add(finalObj);
        }
    }

    public int getRecipeSize() {
        return this.input.size();
    }

    public ItemStack getRecipeOutput() {
        return this.output;
    }

    public ItemStack getCraftingResult(InventoryCrafting var1) {
        return this.output.copy();
    }

    public boolean matches(InventoryCrafting var1, World world) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        for (int x = 0; x < var1.getSizeInventory(); ++x) {
            ItemStack slot = var1.getStackInSlot(x);
            if (slot == null) continue;
            boolean inRecipe = false;
            Iterator<Object> req = required.iterator();
            while (req.hasNext()) {
                boolean match = false;
                Object next = req.next();
                if (next instanceof Integer) {
                    if (slot != null && slot.getItem() instanceof IBloodOrb) {
                        IBloodOrb orb = (IBloodOrb)slot.getItem();
                        if (orb.getOrbLevel() < (Integer)next) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                    match = true;
                } else if (next instanceof ItemStack) {
                    match = OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)slot, (boolean)false);
                } else if (next instanceof ArrayList) {
                    Iterator itr = ((ArrayList)next).iterator();
                    while (itr.hasNext() && !match) {
                        match = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                }
                if (!match) continue;
                inRecipe = true;
                required.remove(next);
                break;
            }
            if (inRecipe) continue;
            return false;
        }
        return required.isEmpty();
    }

    public ArrayList<Object> getInput() {
        return this.input;
    }
}

