/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.soulNetwork;

import WayofTime.alchemicalWizardry.api.event.AddToNetworkEvent;
import WayofTime.alchemicalWizardry.api.event.ItemBindEvent;
import WayofTime.alchemicalWizardry.api.event.ItemDrainInContainerEvent;
import WayofTime.alchemicalWizardry.api.event.ItemDrainNetworkEvent;
import WayofTime.alchemicalWizardry.api.soulNetwork.LifeEssenceNetwork;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.MinecraftForge;

public class SoulNetworkHandler {
    public static boolean syphonFromNetworkWhileInContainer(ItemStack ist, int damageToBeDone) {
        ItemDrainInContainerEvent event;
        String ownerName = "";
        if (ist.getTagCompound() != null && !ist.getTagCompound().getString("ownerName").equals("")) {
            ownerName = ist.getTagCompound().getString("ownerName");
        }
        if (MinecraftForge.EVENT_BUS.post((Event)(event = new ItemDrainInContainerEvent(ist, ownerName, damageToBeDone))) || event.getResult() == Event.Result.DENY) {
            return false;
        }
        return SoulNetworkHandler.syphonFromNetwork(event.ownerNetwork, event.drainAmount) >= damageToBeDone;
    }

    public static int getCurrentMaxOrb(String ownerName) {
        if (MinecraftServer.getServer() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        return data.maxOrb;
    }

    public static void setMaxOrbToMax(String ownerName, int maxOrb) {
        if (MinecraftServer.getServer() == null) {
            return;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        data.maxOrb = Math.max(maxOrb, data.maxOrb);
        data.markDirty();
    }

    public static int getMaximumForOrbTier(int maxOrb) {
        switch (maxOrb) {
            case 1: {
                return 5000;
            }
            case 2: {
                return 25000;
            }
            case 3: {
                return 150000;
            }
            case 4: {
                return 1000000;
            }
            case 5: {
                return 10000000;
            }
            case 6: {
                return 30000000;
            }
        }
        return 1;
    }

    public static int syphonFromNetwork(ItemStack ist, int damageToBeDone) {
        if (ist.getTagCompound() != null && !ist.getTagCompound().getString("ownerName").equals("")) {
            String ownerName = ist.getTagCompound().getString("ownerName");
            return SoulNetworkHandler.syphonFromNetwork(ownerName, damageToBeDone);
        }
        return 0;
    }

    public static int syphonFromNetwork(String ownerName, int damageToBeDone) {
        if (MinecraftServer.getServer() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        if (data.currentEssence >= damageToBeDone) {
            data.currentEssence -= damageToBeDone;
            data.markDirty();
            return damageToBeDone;
        }
        return 0;
    }

    public static boolean syphonAndDamageFromNetwork(ItemStack ist, EntityPlayer player, int drain) {
        if (player.worldObj.isRemote) {
            return false;
        }
        if (ist.getTagCompound() != null && !ist.getTagCompound().getString("ownerName").equals("")) {
            String ownerName = ist.getTagCompound().getString("ownerName");
            ItemDrainNetworkEvent event = new ItemDrainNetworkEvent(player, ownerName, ist, drain);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            int drainAmount = SoulNetworkHandler.syphonFromNetwork(event.ownerNetwork, event.drainAmount);
            if (drainAmount == 0 || event.shouldDamage) {
                SoulNetworkHandler.hurtPlayer(player, event.damageAmount);
            }
            return event.getResult() != Event.Result.DENY;
        }
        int amount = SoulNetworkHandler.syphonFromNetwork(ist, drain);
        SoulNetworkHandler.hurtPlayer(player, drain - amount);
        return true;
    }

    public static boolean syphonAndDamageFromNetwork(String ownerName, EntityPlayer player, int damageToBeDone) {
        if (player.worldObj.isRemote) {
            return false;
        }
        World world = player.worldObj;
        if (world != null) {
            world.playSoundEffect((double)((float)player.posX + 0.5f), (double)((float)player.posY + 0.5f), (double)((float)player.posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        }
        int amount = SoulNetworkHandler.syphonFromNetwork(ownerName, damageToBeDone);
        SoulNetworkHandler.hurtPlayer(player, damageToBeDone - amount);
        return true;
    }

    public static boolean canSyphonFromOnlyNetwork(ItemStack ist, int damageToBeDone) {
        if (ist.getTagCompound() != null && !ist.getTagCompound().getString("ownerName").equals("")) {
            String ownerName = ist.getTagCompound().getString("ownerName");
            return SoulNetworkHandler.canSyphonFromOnlyNetwork(ownerName, damageToBeDone);
        }
        return false;
    }

    public static boolean canSyphonFromOnlyNetwork(String ownerName, int damageToBeDone) {
        if (MinecraftServer.getServer() == null) {
            return false;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        return data.currentEssence >= damageToBeDone;
    }

    public static int getCurrentEssence(String ownerName) {
        if (MinecraftServer.getServer() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        return data.currentEssence;
    }

    public static void setCurrentEssence(String ownerName, int essence) {
        if (MinecraftServer.getServer() == null) {
            return;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, ownerName);
        if (data == null) {
            data = new LifeEssenceNetwork(ownerName);
            world.setItemData(ownerName, (WorldSavedData)data);
        }
        data.currentEssence = essence;
        data.markDirty();
    }

    public static int addCurrentEssenceToMaximum(String ownerName, int addedEssence, int maximum) {
        int currEss;
        AddToNetworkEvent event = new AddToNetworkEvent(ownerName, addedEssence, maximum);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return 0;
        }
        if (MinecraftServer.getServer() == null) {
            return 0;
        }
        WorldServer world = MinecraftServer.getServer().worldServers[0];
        LifeEssenceNetwork data = (LifeEssenceNetwork)world.loadItemData(LifeEssenceNetwork.class, event.ownerNetwork);
        if (data == null) {
            data = new LifeEssenceNetwork(event.ownerNetwork);
            world.setItemData(event.ownerNetwork, (WorldSavedData)data);
        }
        if ((currEss = data.currentEssence) >= event.maximum) {
            return 0;
        }
        int newEss = Math.min(event.maximum, currEss + event.addedAmount);
        if (event.getResult() != Event.Result.DENY) {
            data.currentEssence = newEss;
        }
        return newEss - currEss;
    }

    public static void hurtPlayer(EntityPlayer user, int energySyphoned) {
        block4: {
            block3: {
                if (energySyphoned >= 100 || energySyphoned <= 0) break block3;
                if (user.capabilities.isCreativeMode) break block4;
                user.setHealth(user.getHealth() - 1.0f);
                if (user.getHealth() <= 5.0E-4f) {
                    user.onDeath(DamageSource.generic);
                }
                break block4;
            }
            if (energySyphoned >= 100 && !user.capabilities.isCreativeMode) {
                for (int i = 0; i < (energySyphoned + 99) / 100; ++i) {
                    user.setHealth(user.getHealth() - 1.0f);
                    if (!(user.getHealth() <= 5.0E-4f)) continue;
                    user.onDeath(DamageSource.generic);
                    break;
                }
            }
        }
    }

    public static void hurtPlayer(EntityPlayer user, float damage) {
        if (!user.capabilities.isCreativeMode) {
            user.setHealth(user.getHealth() - damage);
            if (user.getHealth() <= 5.0E-4f) {
                user.onDeath(DamageSource.generic);
            }
        }
    }

    public static void checkAndSetItemOwner(ItemStack item, EntityPlayer player) {
        SoulNetworkHandler.checkAndSetItemPlayer(item, player);
    }

    public static boolean checkAndSetItemPlayer(ItemStack item, EntityPlayer player) {
        if (item.hasTagCompound() && !item.getTagCompound().getString("ownerName").equals("")) {
            return true;
        }
        ItemBindEvent event = new ItemBindEvent(player, SoulNetworkHandler.getUsername(player), item);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            if (!item.hasTagCompound()) {
                item.setTagCompound(new NBTTagCompound());
            }
            item.getTagCompound().setString("ownerName", event.key);
            return true;
        }
        return false;
    }

    public static void checkAndSetItemOwner(ItemStack item, String ownerName) {
        if (item.getTagCompound() == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        if (item.getTagCompound().getString("ownerName").equals("")) {
            item.getTagCompound().setString("ownerName", ownerName);
        }
    }

    public static String getUsername(EntityPlayer player) {
        return player.getCommandSenderName();
    }

    public static EntityPlayer getPlayerForUsername(String str) {
        if (MinecraftServer.getServer() == null) {
            return null;
        }
        return MinecraftServer.getServer().getConfigurationManager().func_152612_a(str);
    }

    public static void causeNauseaToPlayer(ItemStack stack) {
        if (stack.getTagCompound() != null && !stack.getTagCompound().getString("ownerName").equals("")) {
            String ownerName = stack.getTagCompound().getString("ownerName");
            SoulNetworkHandler.causeNauseaToPlayer(ownerName);
        }
    }

    public static void causeNauseaToPlayer(String ownerName) {
        EntityPlayer entityOwner = SoulNetworkHandler.getPlayerForUsername(ownerName);
        if (entityOwner == null) {
            return;
        }
        entityOwner.addPotionEffect(new PotionEffect(Potion.confusion.id, 80));
    }

    public static String getOwnerName(ItemStack item) {
        if (item.getTagCompound() == null) {
            item.setTagCompound(new NBTTagCompound());
        }
        return item.getTagCompound().getString("ownerName");
    }
}

