/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.api.summoningRegistry;

import WayofTime.alchemicalWizardry.api.summoningRegistry.SummoningHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class SummoningRegistryComponent {
    public ItemStack[] ring1 = new ItemStack[6];
    public ItemStack[] ring2 = new ItemStack[6];
    public ItemStack[] ring3 = new ItemStack[6];
    public SummoningHelper summoningHelper;
    public int summoningCost;
    public int bloodOrbLevel;

    public SummoningRegistryComponent(SummoningHelper s, ItemStack[] newRing1, ItemStack[] newRing2, ItemStack[] newRing3, int amount, int bloodOrbLevel) {
        int i;
        ItemStack[] newRecipe;
        this.summoningHelper = s;
        this.ring1 = newRing1;
        this.ring2 = newRing2;
        this.ring3 = newRing3;
        this.summoningCost = amount;
        this.bloodOrbLevel = bloodOrbLevel;
        if (this.ring1.length != 6) {
            newRecipe = new ItemStack[6];
            for (i = 0; i < 6; ++i) {
                newRecipe[i] = i + 1 > this.ring1.length ? null : this.ring1[i];
            }
            this.ring1 = newRecipe;
        }
        if (this.ring2.length != 6) {
            newRecipe = new ItemStack[6];
            for (i = 0; i < 6; ++i) {
                newRecipe[i] = i + 1 > this.ring2.length ? null : this.ring2[i];
            }
            this.ring2 = newRecipe;
        }
        if (this.ring3.length != 6) {
            newRecipe = new ItemStack[6];
            for (i = 0; i < 6; ++i) {
                newRecipe[i] = i + 1 > this.ring3.length ? null : this.ring3[i];
            }
            this.ring3 = newRecipe;
        }
    }

    public boolean compareRing(int ring, ItemStack[] checkedRingRecipe) {
        int i;
        ItemStack[] recipe;
        if (checkedRingRecipe.length < 6) {
            return false;
        }
        switch (ring) {
            case 1: {
                recipe = this.ring1;
                break;
            }
            case 2: {
                recipe = this.ring2;
                break;
            }
            case 3: {
                recipe = this.ring3;
                break;
            }
            default: {
                recipe = this.ring1;
            }
        }
        if (recipe.length != 6) {
            ItemStack[] newRecipe = new ItemStack[6];
            for (i = 0; i < 6; ++i) {
                newRecipe[i] = i + 1 > recipe.length ? null : recipe[i];
            }
            recipe = newRecipe;
        }
        boolean[] checkList = new boolean[6];
        for (i = 0; i < 6; ++i) {
            checkList[i] = false;
        }
        for (i = 0; i < 6; ++i) {
            ItemStack recipeItemStack = recipe[i];
            if (recipeItemStack == null) continue;
            boolean test = false;
            for (int j = 0; j < 6; ++j) {
                ItemStack checkedItemStack;
                if (checkList[j] || (checkedItemStack = checkedRingRecipe[j]) == null) continue;
                boolean quickTest = false;
                if (recipeItemStack.getItem() instanceof ItemBlock) {
                    if (checkedItemStack.getItem() instanceof ItemBlock) {
                        quickTest = true;
                    }
                } else if (!(checkedItemStack.getItem() instanceof ItemBlock)) {
                    quickTest = true;
                }
                if (!quickTest || checkedItemStack.getItemDamage() != recipeItemStack.getItemDamage() && Short.MAX_VALUE != recipeItemStack.getItemDamage() || checkedItemStack.getItem() != recipeItemStack.getItem()) continue;
                test = true;
                checkList[j] = true;
                break;
            }
            if (test) continue;
            return false;
        }
        return true;
    }

    public int getSummoningCost() {
        return this.summoningCost;
    }

    public EntityLivingBase getEntity(World world) {
        return this.summoningHelper.getEntity(world);
    }

    public int getBloodOrbLevel() {
        return this.bloodOrbLevel;
    }

    public ItemStack[] getRingRecipeForRing(int ring) {
        switch (ring) {
            case 1: {
                return this.ring1;
            }
            case 2: {
                return this.ring2;
            }
            case 3: {
                return this.ring3;
            }
        }
        return null;
    }

    public String getSummoningHelperID() {
        return this.summoningHelper.getSummoningHelperID();
    }
}

