/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.alchemy.energy.Reagent;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentContainer;
import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.common.tileEntity.TEBellJar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class BlockBelljar
extends BlockContainer {
    public BlockBelljar() {
        super(Material.glass);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setBlockName("crystalBelljar");
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        if (((Object)((Object)this)).equals(ModBlocks.blockCrystalBelljar)) {
            par3List.add(new ItemStack(par1, 1, 0));
            for (Reagent reagent : ReagentRegistry.reagentList.values()) {
                ItemStack stack = new ItemStack(par1, 1, 0);
                NBTTagCompound tag = new NBTTagCompound();
                ReagentContainer[] tanks = new ReagentContainer[]{new ReagentContainer(reagent, 16000, 16000)};
                NBTTagList tagList = new NBTTagList();
                NBTTagCompound savedTag = new NBTTagCompound();
                if (tanks[0] != null) {
                    tanks[0].writeToNBT(savedTag);
                }
                tagList.appendTag((NBTBase)savedTag);
                tag.setTag("reagentTanks", (NBTBase)tagList);
                stack.setTagCompound(tag);
                par3List.add(stack);
            }
        } else {
            super.getSubBlocks(par1, par2CreativeTabs, par3List);
        }
    }

    public void onBlockPlacedBy(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        NBTTagCompound tag;
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TEBellJar && (tag = stack.getTagCompound()) != null) {
            ((TEBellJar)tile).readTankNBTOnPlace(tag);
        }
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TEBellJar();
    }

    public boolean renderAsNormalBlock() {
        return false;
    }

    public int getRenderType() {
        return -1;
    }

    public boolean isOpaqueCube() {
        return false;
    }

    public boolean hasTileEntity() {
        return true;
    }

    public boolean hasComparatorInputOverride() {
        return true;
    }

    public int getComparatorInputOverride(World world, int x, int y, int z, int meta) {
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TEBellJar) {
            return ((TEBellJar)tile).getRSPowerOutput();
        }
        return 15;
    }

    public void onBlockHarvested(World world, int x, int y, int z, int meta, EntityPlayer player) {
        this.dropBlockAsItem(world, x, y, z, meta, 0);
        super.onBlockHarvested(world, x, y, z, meta, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof TEBellJar) {
            ItemStack drop = new ItemStack((Block)this);
            NBTTagCompound tag = new NBTTagCompound();
            ((TEBellJar)tile).writeTankNBT(tag);
            drop.setTagCompound(tag);
            list.add(drop);
        }
        return list;
    }
}

