/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.block;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class ImperfectRitualStone
extends Block {
    public ImperfectRitualStone() {
        super(Material.iron);
        this.setHardness(2.0f);
        this.setResistance(5.0f);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setBlockName("imperfectRitualStone");
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockIcons(IIconRegister iconRegister) {
        this.blockIcon = iconRegister.registerIcon("AlchemicalWizardry:ImperfectRitualStone");
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer player, int side, float xOff, float yOff, float zOff) {
        if (SpellHelper.isFakePlayer(player)) {
            return false;
        }
        Block block = world.getBlock(x, y + 1, z);
        if (block == Blocks.water && !AlchemicalWizardry.ritualWeakDisabledThunderstorm) {
            if (!player.capabilities.isCreativeMode && !world.isRemote) {
                EnergyItems.drainPlayerNetwork(player, AlchemicalWizardry.ritualWeakCostThunderstorm);
            }
            if (!world.isRemote) {
                world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 2), (double)z));
            }
            world.getWorldInfo().setRaining(true);
            if (world.isRemote) {
                world.setRainStrength(1.0f);
                world.setThunderStrength(1.0f);
            }
            world.getWorldInfo().setThunderTime(0);
            world.getWorldInfo().setThundering(true);
            return true;
        }
        if (block == Blocks.coal_block && !AlchemicalWizardry.ritualWeakDisabledZombie) {
            if (!player.capabilities.isCreativeMode && !world.isRemote) {
                EnergyItems.drainPlayerNetwork(player, AlchemicalWizardry.ritualWeakCostZombie);
            }
            EntityZombie zomb = new EntityZombie(world);
            zomb.setPosition((double)x + 0.5, (double)(y + 2), (double)z + 0.5);
            zomb.addPotionEffect(new PotionEffect(Potion.fireResistance.id, 2000));
            zomb.addPotionEffect(new PotionEffect(Potion.damageBoost.id, 20000, 7));
            zomb.addPotionEffect(new PotionEffect(Potion.resistance.id, 20000, 3));
            if (!world.isRemote) {
                world.spawnEntityInWorld((Entity)zomb);
                world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 2), (double)z));
            }
            return true;
        }
        if (block == Blocks.lapis_block && !AlchemicalWizardry.ritualWeakDisabledNight) {
            if (!player.capabilities.isCreativeMode && !world.isRemote) {
                EnergyItems.drainPlayerNetwork(player, AlchemicalWizardry.ritualWeakCostNight);
            }
            if (!world.isRemote) {
                world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 2), (double)z));
                world.setWorldTime(world.getWorldTime() / 24000L * 24000L + 13800L);
            }
        } else if (block == Blocks.bedrock && !AlchemicalWizardry.ritualWeakDisabledResistance) {
            if (!player.capabilities.isCreativeMode && !world.isRemote) {
                EnergyItems.drainPlayerNetwork(player, AlchemicalWizardry.ritualWeakCostResistance);
            }
            if (!world.isRemote) {
                world.addWeatherEffect((Entity)new EntityLightningBolt(world, (double)x, (double)(y + 2), (double)z));
            }
            player.addPotionEffect(new PotionEffect(Potion.resistance.id, 1200, 1));
        }
        return false;
    }
}

