/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.commands;

import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import java.util.List;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;

public class CommandBind
extends CommandBase {
    public String getCommandName() {
        return "bind";
    }

    public int getRequiredPermissionLevel() {
        return 2;
    }

    public String getCommandUsage(ICommandSender icommandsender) {
        return "commands.bind.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processCommand(ICommandSender iCommandSender, String[] astring) {
        EntityPlayerMP entityplayermp = CommandBind.getCommandSenderAsPlayer((ICommandSender)iCommandSender);
        ItemStack item = entityplayermp.getCurrentEquippedItem();
        EntityPlayerMP targetPlayer = CommandBind.getPlayer((ICommandSender)iCommandSender, (String)astring[0]);
        if (targetPlayer == null) {
            throw new CommandException("commands.bind.failed.noPlayer", new Object[0]);
        }
        if (item != null && item.getItem() instanceof IBindable) {
            if (!EnergyItems.getOwnerName(item).isEmpty()) throw new CommandException("commands.bind.failed.alreadyBound", new Object[0]);
            EnergyItems.checkAndSetItemOwner(item, (EntityPlayer)targetPlayer);
            CommandBind.func_152373_a((ICommandSender)iCommandSender, (ICommand)this, (String)"commands.bind.success", (Object[])new Object[0]);
            return;
        } else {
            if (item.getItem() instanceof IBindable) return;
            throw new CommandException("commands.bind.failed.notBindable", new Object[0]);
        }
    }

    public List addTabCompletionOptions(ICommandSender iCommandSender, String[] astring) {
        return CommandBind.getListOfStringsMatchingLastWord((String[])astring, (String[])this.getPlayer());
    }

    protected String[] getPlayer() {
        return MinecraftServer.getServer().getAllUsernames();
    }

    public boolean isUsernameIndex(String[] astring, int par2) {
        return par2 == 0;
    }
}

