/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.commands.sub;

import WayofTime.alchemicalWizardry.api.command.SubCommandBase;
import WayofTime.alchemicalWizardry.api.soulNetwork.SoulNetworkHandler;
import java.util.Locale;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class SubCommandNetwork
extends SubCommandBase {
    public SubCommandNetwork(ICommand parent) {
        super(parent, "network");
    }

    @Override
    public String getArgUsage(ICommandSender commandSender) {
        return StatCollector.translateToLocal((String)"commands.network.usage");
    }

    @Override
    public String getHelpText() {
        return StatCollector.translateToLocal((String)"commands.network.help");
    }

    @Override
    public int getRequiredPermissionLevel() {
        return 0;
    }

    @Override
    public void processSubCommand(ICommandSender commandSender, String[] args) {
        super.processSubCommand(commandSender, args);
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("help")) {
                return;
            }
            String givenName = commandSender.getCommandSenderName();
            EntityPlayerMP player = this.getPlayer(commandSender, givenName);
            if (args.length > 1) {
                givenName = args[1];
                player = this.getPlayer(commandSender, givenName);
            }
            boolean displayHelp = this.isBounded(0, 2, args.length);
            try {
                switch (ValidCommands.valueOf(args[0].toUpperCase(Locale.ENGLISH))) {
                    case SYPHON: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.SYPHON.help, new Object[0]);
                            break;
                        }
                        if (args.length == 3) {
                            if (SubCommandNetwork.isInteger(args[2])) {
                                int amount = Integer.parseInt(args[2]);
                                SoulNetworkHandler.syphonAndDamageFromNetwork(givenName, (EntityPlayer)player, amount);
                                this.displaySuccessString(commandSender, "commands.network.syphon.success", amount, givenName);
                                break;
                            }
                            this.displayErrorString(commandSender, "commands.error.arg.invalid", new Object[0]);
                            break;
                        }
                        this.displayErrorString(commandSender, "commands.error.arg.missing", new Object[0]);
                        break;
                    }
                    case ADD: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.ADD.help, new Object[0]);
                            break;
                        }
                        if (args.length == 3) {
                            if (SubCommandNetwork.isInteger(args[2])) {
                                int amount = Integer.parseInt(args[2]);
                                int maxOrb = SoulNetworkHandler.getMaximumForOrbTier(SoulNetworkHandler.getCurrentMaxOrb(givenName));
                                SoulNetworkHandler.addCurrentEssenceToMaximum(givenName, amount, maxOrb);
                                this.displaySuccessString(commandSender, "commands.network.add.success", amount, givenName);
                                break;
                            }
                            this.displayErrorString(commandSender, "commands.error.arg.invalid", new Object[0]);
                            break;
                        }
                        this.displayErrorString(commandSender, "commands.error.arg.missing", new Object[0]);
                        break;
                    }
                    case SET: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.SET.help, new Object[0]);
                            break;
                        }
                        if (args.length == 3) {
                            if (SubCommandNetwork.isInteger(args[2])) {
                                int amount = Integer.parseInt(args[2]);
                                SoulNetworkHandler.setCurrentEssence(givenName, amount);
                                this.displaySuccessString(commandSender, "commands.network.set.success", givenName, amount);
                                break;
                            }
                            this.displayErrorString(commandSender, "commands.error.arg.invalid", new Object[0]);
                            break;
                        }
                        this.displayErrorString(commandSender, "commands.error.arg.missing", new Object[0]);
                        break;
                    }
                    case GET: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.GET.help, new Object[0]);
                            break;
                        }
                        if (args.length <= 1) break;
                        commandSender.addChatMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"message.divinationsigil.currentessence") + " " + SoulNetworkHandler.getCurrentEssence(givenName) + "LP"));
                        break;
                    }
                    case FILL: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.FILL.help, Integer.MAX_VALUE);
                            break;
                        }
                        if (args.length <= 1) break;
                        SoulNetworkHandler.setCurrentEssence(givenName, Integer.MAX_VALUE);
                        this.displaySuccessString(commandSender, "commands.network.fill.success", givenName);
                        break;
                    }
                    case CAP: {
                        if (displayHelp) {
                            this.displayHelpString(commandSender, ValidCommands.CAP.help, new Object[0]);
                            break;
                        }
                        if (args.length <= 1) break;
                        int maxOrb = SoulNetworkHandler.getMaximumForOrbTier(SoulNetworkHandler.getCurrentMaxOrb(givenName));
                        SoulNetworkHandler.setCurrentEssence(givenName, maxOrb);
                        this.displaySuccessString(commandSender, "commands.network.cap.success", givenName);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                this.displayErrorString(commandSender, "commands.error.404", new Object[0]);
            }
        }
    }

    private static boolean isInteger(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        return true;
    }

    private static enum ValidCommands {
        SYPHON("commands.network.syphon.help"),
        ADD("commands.network.add.help"),
        SET("commands.network.set.help"),
        GET("commands.network.get.help"),
        FILL("commands.network.fill.help"),
        CAP("commands.network.cap.help");

        public String help;

        private ValidCommands(String help) {
            this.help = help;
        }
    }
}

