/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.demonVillage;

import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.common.demonVillage.BlockSet;
import WayofTime.alchemicalWizardry.common.demonVillage.GridSpace;
import WayofTime.alchemicalWizardry.common.demonVillage.GridSpaceHolder;
import WayofTime.alchemicalWizardry.common.demonVillage.tileEntity.TEDemonPortal;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BuildingSchematic {
    public String name;
    public int doorX;
    public int doorZ;
    public int doorY;
    public int buildingTier;
    public int buildingType;
    public List<BlockSet> blockList;

    public BuildingSchematic() {
        this("");
    }

    public BuildingSchematic(String name) {
        this.name = name;
        this.blockList = new ArrayList<BlockSet>();
        this.doorX = 0;
        this.doorZ = 0;
        this.doorY = 0;
        this.buildingTier = 0;
        this.buildingType = 0;
    }

    public void addBlockWithMeta(Block block, int meta, int xOffset, int yOffset, int zOffset) {
        for (BlockSet set : this.blockList) {
            if (!set.isContained(block, meta)) continue;
            set.addPositionToBlock(xOffset, yOffset, zOffset);
            return;
        }
        BlockSet set = new BlockSet(block, meta);
        set.addPositionToBlock(xOffset, yOffset, zOffset);
        this.blockList.add(set);
    }

    public void buildAll(TEDemonPortal teDemonPortal, World world, int xCoord, int yCoord, int zCoord, ForgeDirection dir, boolean populateInventories) {
        for (BlockSet set : this.blockList) {
            set.buildAll(teDemonPortal, world, xCoord, yCoord, zCoord, dir, populateInventories, this.buildingTier);
        }
    }

    public GridSpaceHolder createGSH() {
        GridSpaceHolder holder = new GridSpaceHolder();
        for (BlockSet set : this.blockList) {
            for (Int3 coords : set.getPositions()) {
                int gridX = (int)(((float)coords.xCoord + 2.0f * Math.signum(coords.xCoord)) / 5.0f);
                int gridZ = (int)(((float)coords.zCoord + 2.0f * Math.signum(coords.zCoord)) / 5.0f);
                holder.setGridSpace(gridX, gridZ, new GridSpace(5, 0));
            }
        }
        return holder;
    }

    public Int3 getGridSpotOfDoor() {
        int gridX = (int)(((float)this.doorX + 2.0f * Math.signum(this.doorX)) / 5.0f);
        int gridZ = (int)(((float)this.doorZ + 2.0f * Math.signum(this.doorZ)) / 5.0f);
        return new Int3(gridX, this.doorY, gridZ);
    }

    public List<Int3> getGriddedPositions(ForgeDirection dir) {
        ArrayList<Int3> positionList = new ArrayList<Int3>();
        for (BlockSet blockSet : this.blockList) {
            for (Int3 pos : blockSet.getPositions()) {
                Int3 nextPos;
                int xOff = pos.xCoord;
                int zOff = pos.zCoord;
                switch (dir) {
                    case SOUTH: {
                        xOff *= -1;
                        zOff *= -1;
                        break;
                    }
                    case WEST: {
                        int temp = zOff;
                        zOff = xOff * -1;
                        xOff = temp;
                        break;
                    }
                    case EAST: {
                        int temp2 = zOff * -1;
                        zOff = xOff;
                        xOff = temp2;
                        break;
                    }
                }
                if (positionList.contains(nextPos = new Int3(xOff, 0, zOff))) continue;
                positionList.add(nextPos);
            }
        }
        return positionList;
    }

    public void destroyAllInField(World world, int xCoord, int yCoord, int zCoord, ForgeDirection dir) {
        List<Int3> positionList = this.getGriddedPositions(dir);
        for (int i = this.getMinY(); i <= this.getMaxY(); ++i) {
            for (Int3 pos : positionList) {
                Block block = world.getBlock(xCoord + pos.xCoord, yCoord + i, zCoord + pos.zCoord);
                if (block == ModBlocks.blockDemonPortal) continue;
                world.setBlockToAir(xCoord + pos.xCoord, yCoord + i, zCoord + pos.zCoord);
            }
        }
    }

    public int getMinY() {
        int min = 0;
        for (BlockSet set : this.blockList) {
            for (Int3 pos : set.getPositions()) {
                if (pos.yCoord >= min) continue;
                min = pos.yCoord;
            }
        }
        return min;
    }

    public int getMaxY() {
        int max = 0;
        for (BlockSet set : this.blockList) {
            for (Int3 pos : set.getPositions()) {
                if (pos.yCoord <= max) continue;
                max = pos.yCoord;
            }
        }
        return max;
    }

    public String getName() {
        return this.name;
    }
}

