/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.mob;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.book.BloodMagicGuide;
import WayofTime.alchemicalWizardry.common.entity.mob.BookEntityItem;
import amerifrance.guideapi.api.GuideRegistry;
import amerifrance.guideapi.api.base.Book;
import cpw.mods.fml.common.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import pneumaticCraft.api.PneumaticRegistry;

public class MailOrderEntityItem
extends EntityItem {
    public MailOrderEntityItem(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
        this.isImmuneToFire = true;
        this.lifespan = 72000;
    }

    public MailOrderEntityItem(World par1World, double par2, double par4, double par6, ItemStack par8ItemStack) {
        this(par1World, par2, par4, par6);
        this.setEntityItemStack(par8ItemStack);
        this.isImmuneToFire = true;
        this.lifespan = par8ItemStack.getItem() == null ? 6000 : par8ItemStack.getItem().getEntityLifespan(par8ItemStack, par1World);
    }

    public MailOrderEntityItem(World world, Entity original, ItemStack stack) {
        this(world, original.posX, original.posY, original.posZ);
        this.delayBeforeCanPickup = 20;
        this.motionX = original.motionX;
        this.motionY = original.motionY;
        this.motionZ = original.motionZ;
        this.setEntityItemStack(stack);
        this.isImmuneToFire = true;
    }

    public MailOrderEntityItem(World par1world) {
        super(par1world);
    }

    public void onUpdate() {
        super.onUpdate();
        if (!this.worldObj.isRemote && this.ticksExisted > 100 && !this.isDead) {
            this.worldObj.addWeatherEffect((Entity)new EntityLightningBolt(this.worldObj, this.posX, this.posY, this.posZ));
            if (AlchemicalWizardry.isPneumaticCraftLoaded) {
                this.deliverItemViaDrone(this.posX, this.posY, this.posZ);
            } else {
                BookEntityItem entity = new BookEntityItem(this.worldObj, this.posX, this.posY, this.posZ, GuideRegistry.getItemStackForBook((Book)BloodMagicGuide.bloodMagicGuide));
                entity.lifespan = 6000;
                entity.delayBeforeCanPickup = 20;
                entity.motionY = 1.0;
                this.worldObj.spawnEntityInWorld((Entity)entity);
            }
            this.setDead();
        }
    }

    @Optional.Method(modid="PneumaticCraft")
    public void deliverItemViaDrone(double x, double y, double z) {
        PneumaticRegistry.getInstance().deliverItemsAmazonStyle(this.worldObj, (int)x, (int)y, (int)z, new ItemStack[]{GuideRegistry.getItemStackForBook((Book)BloodMagicGuide.bloodMagicGuide)});
    }
}

