/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.common.registry.IThrowableEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EnergyBlastProjectile
extends Entity
implements IProjectile,
IThrowableEntity {
    protected int xTile = -1;
    protected int yTile = -1;
    protected int zTile = -1;
    protected int inTile = 0;
    protected int inData = 0;
    protected boolean inGround = false;
    public EntityLivingBase shootingEntity;
    protected int ticksInAir = 0;
    protected int maxTicksInAir = 600;
    private int ricochetCounter = 0;
    private boolean scheduledForDeath = false;
    protected int projectileDamage;

    public EnergyBlastProjectile(World par1World) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
        this.maxTicksInAir = 600;
    }

    public EnergyBlastProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World);
        this.setSize(0.5f, 0.5f);
        this.setPosition(par2, par4, par6);
        this.yOffset = 0.0f;
        this.maxTicksInAir = 600;
    }

    public EnergyBlastProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(par2EntityPlayer.posX, par2EntityPlayer.posY + (double)par2EntityPlayer.getEyeHeight(), par2EntityPlayer.posZ, par2EntityPlayer.rotationYaw, par2EntityPlayer.rotationPitch);
        this.posX -= (double)(MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.posY -= 0.2;
        this.posZ -= (double)(MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * 0.16f);
        this.setPosition(this.posX, this.posY, this.posZ);
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(this.rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(this.rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, par3 * 1.5f, 1.0f);
        this.projectileDamage = damage;
        this.maxTicksInAir = 600;
    }

    public EnergyBlastProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        super(par1World);
        this.shootingEntity = par2EntityPlayer;
        float par3 = 0.8f;
        this.setSize(0.5f, 0.5f);
        this.setLocationAndAngles(posX, posY, posZ, rotationYaw, rotationPitch);
        this.setPosition(posX -= (double)(MathHelper.cos((float)(rotationYaw / 180.0f * (float)Math.PI)) * 0.16f), posY -= 0.2, posZ -= (double)(MathHelper.sin((float)(rotationYaw / 180.0f * (float)Math.PI)) * 0.16f));
        this.yOffset = 0.0f;
        this.motionX = -MathHelper.sin((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.motionZ = MathHelper.cos((float)(rotationYaw / 180.0f * (float)Math.PI)) * MathHelper.cos((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.motionY = -MathHelper.sin((float)(rotationPitch / 180.0f * (float)Math.PI));
        this.setThrowableHeading(this.motionX, this.motionY, this.motionZ, par3 * 1.5f, 1.0f);
        this.projectileDamage = damage;
        this.maxTicksInAir = maxTicksInAir;
    }

    public EnergyBlastProjectile(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir) {
        super(par1World);
        this.renderDistanceWeight = 10.0;
        this.shootingEntity = par2EntityLivingBase;
        this.posY = par2EntityLivingBase.posY + (double)par2EntityLivingBase.getEyeHeight() - (double)0.1f;
        double d0 = par3EntityLivingBase.posX - par2EntityLivingBase.posX;
        double d1 = par3EntityLivingBase.boundingBox.minY + (double)(par3EntityLivingBase.height / 1.5f) - this.posY;
        double d2 = par3EntityLivingBase.posZ - par2EntityLivingBase.posZ;
        double d3 = MathHelper.sqrt_double((double)(d0 * d0 + d2 * d2));
        if (d3 >= 1.0E-7) {
            float f2 = (float)(Math.atan2(d2, d0) * 180.0 / Math.PI) - 90.0f;
            float f3 = (float)(-(Math.atan2(d1, d3) * 180.0 / Math.PI));
            double d4 = d0 / d3;
            double d5 = d2 / d3;
            this.setLocationAndAngles(par2EntityLivingBase.posX + d4, this.posY, par2EntityLivingBase.posZ + d5, f2, f3);
            this.yOffset = 0.0f;
            float f4 = (float)d3 * 0.2f;
            this.setThrowableHeading(d0, d1, d2, par4, par5);
        }
        this.projectileDamage = damage;
        this.maxTicksInAir = maxTicksInAir;
    }

    protected void entityInit() {
        this.dataWatcher.addObject(16, (Object)0);
    }

    public void setThrowableHeading(double var1, double var3, double var5, float var7, float var8) {
        float var9 = MathHelper.sqrt_double((double)(var1 * var1 + var3 * var3 + var5 * var5));
        var1 /= (double)var9;
        var3 /= (double)var9;
        var5 /= (double)var9;
        var1 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var3 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        var5 += this.rand.nextGaussian() * (double)0.0075f * (double)var8;
        this.motionX = var1 *= (double)var7;
        this.motionY = var3 *= (double)var7;
        this.motionZ = var5 *= (double)var7;
        float var10 = MathHelper.sqrt_double((double)(var1 * var1 + var5 * var5));
        this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(var1, var5) * 180.0 / Math.PI);
        this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(var3, var10) * 180.0 / Math.PI);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double par1, double par3, double par5, float par7, float par8, int par9) {
        this.setPosition(par1, par3, par5);
        this.setRotation(par7, par8);
    }

    @SideOnly(value=Side.CLIENT)
    public void setVelocity(double par1, double par3, double par5) {
        this.motionX = par1;
        this.motionY = par3;
        this.motionZ = par5;
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var7 = MathHelper.sqrt_double((double)(par1 * par1 + par5 * par5));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch;
            this.prevRotationYaw = this.rotationYaw;
            this.setLocationAndAngles(this.posX, this.posY, this.posZ, this.rotationYaw, this.rotationPitch);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onUpdate() {
        Block var16;
        super.onUpdate();
        if (this.ticksInAir > this.maxTicksInAir) {
            this.setDead();
        }
        if (this.shootingEntity == null) {
            List players = this.worldObj.getEntitiesWithinAABB(EntityPlayer.class, AxisAlignedBB.getBoundingBox((double)(this.posX - 1.0), (double)(this.posY - 1.0), (double)(this.posZ - 1.0), (double)(this.posX + 1.0), (double)(this.posY + 1.0), (double)(this.posZ + 1.0)));
            Iterator i = players.iterator();
            double closestDistance = Double.MAX_VALUE;
            EntityPlayer closestPlayer = null;
            while (i.hasNext()) {
                EntityPlayer e = (EntityPlayer)i.next();
                double distance = e.getDistanceToEntity((Entity)this);
                if (!(distance < closestDistance)) continue;
                closestPlayer = e;
            }
            if (closestPlayer != null) {
                this.shootingEntity = closestPlayer;
            }
        }
        if (this.prevRotationPitch == 0.0f && this.prevRotationYaw == 0.0f) {
            float var1 = MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
            this.prevRotationYaw = this.rotationYaw = (float)(Math.atan2(this.motionX, this.motionZ) * 180.0 / Math.PI);
            this.prevRotationPitch = this.rotationPitch = (float)(Math.atan2(this.motionY, var1) * 180.0 / Math.PI);
        }
        if ((var16 = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile)) != null) {
            var16.setBlockBoundsBasedOnState((IBlockAccess)this.worldObj, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = var16.getCollisionBoundingBoxFromPool(this.worldObj, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.isVecInside(SpellHelper.createVec3(this.posX, this.posY, this.posZ))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            Block var18 = this.worldObj.getBlock(this.xTile, this.yTile, this.zTile);
            int var19 = this.worldObj.getBlockMetadata(this.xTile, this.yTile, this.zTile);
            if (var18.equals(Block.getBlockById((int)this.inTile)) && var19 != this.inData) return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir > 1 && this.ticksInAir < 3) {
            for (int particles = 0; particles < 3; ++particles) {
                this.doFiringParticles();
            }
        }
        Vec3 var17 = SpellHelper.createVec3(this.posX, this.posY, this.posZ);
        Vec3 var3 = SpellHelper.createVec3(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        MovingObjectPosition var4 = this.worldObj.func_147447_a(var17, var3, true, false, false);
        var17 = SpellHelper.createVec3(this.posX, this.posY, this.posZ);
        var3 = SpellHelper.createVec3(this.posX + this.motionX, this.posY + this.motionY, this.posZ + this.motionZ);
        if (var4 != null) {
            var3 = SpellHelper.createVec3(var4.hitVec.xCoord, var4.hitVec.yCoord, var4.hitVec.zCoord);
        }
        Entity var5 = null;
        List var6 = this.worldObj.getEntitiesWithinAABBExcludingEntity((Entity)this, this.boundingBox.addCoord(this.motionX, this.motionY, this.motionZ).expand(1.0, 1.0, 1.0));
        double var7 = 0.0;
        for (Entity var10 : var6) {
            double var14;
            float var11;
            AxisAlignedBB var12;
            MovingObjectPosition var13;
            if (!var10.canBeCollidedWith() || var10 == this.shootingEntity && this.ticksInAir < 5 || (var13 = (var12 = var10.boundingBox.expand((double)(var11 = 0.3f), (double)var11, (double)var11)).calculateIntercept(var17, var3)) == null || !((var14 = var17.distanceTo(var13.hitVec)) < var7) && var7 != 0.0) continue;
            var5 = var10;
            var7 = var14;
        }
        if (var5 != null) {
            var4 = new MovingObjectPosition(var5);
        }
        if (var4 != null) {
            this.onImpact(var4);
            if (this.scheduledForDeath) {
                this.setDead();
            }
        }
        this.posX += this.motionX;
        this.posY += this.motionY;
        this.posZ += this.motionZ;
        MathHelper.sqrt_double((double)(this.motionX * this.motionX + this.motionZ * this.motionZ));
        this.setPosition(this.posX, this.posY, this.posZ);
    }

    public void doFiringParticles() {
        this.worldObj.spawnParticle("mobSpellAmbient", this.posX + this.smallGauss(0.1), this.posY + this.smallGauss(0.1), this.posZ + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        this.worldObj.spawnParticle("flame", this.posX, this.posY, this.posZ, this.gaussian(this.motionX), this.gaussian(this.motionY), this.gaussian(this.motionZ));
    }

    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.setShort("xTile", (short)this.xTile);
        par1NBTTagCompound.setShort("yTile", (short)this.yTile);
        par1NBTTagCompound.setShort("zTile", (short)this.zTile);
        par1NBTTagCompound.setByte("inTile", (byte)this.inTile);
        par1NBTTagCompound.setByte("inData", (byte)this.inData);
        par1NBTTagCompound.setByte("inGround", (byte)(this.inGround ? 1 : 0));
        par1NBTTagCompound.setInteger("ticksInAir", this.ticksInAir);
        par1NBTTagCompound.setInteger("maxTicksInAir", this.maxTicksInAir);
        par1NBTTagCompound.setInteger("projectileDamage", this.projectileDamage);
    }

    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.getShort("xTile");
        this.yTile = par1NBTTagCompound.getShort("yTile");
        this.zTile = par1NBTTagCompound.getShort("zTile");
        this.inTile = par1NBTTagCompound.getByte("inTile") & 0xFF;
        this.inData = par1NBTTagCompound.getByte("inData") & 0xFF;
        this.inGround = par1NBTTagCompound.getByte("inGround") == 1;
        this.ticksInAir = par1NBTTagCompound.getInteger("ticksInAir");
        this.maxTicksInAir = par1NBTTagCompound.getInteger("maxTicksInAir");
        this.projectileDamage = par1NBTTagCompound.getInteger("projectileDamage");
    }

    protected boolean canTriggerWalking() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getShadowSize() {
        return 0.0f;
    }

    public void setKnockbackStrength(int par1) {
    }

    public boolean canAttackWithItem() {
        return false;
    }

    public void setIsCritical(boolean par1) {
        byte var2 = this.dataWatcher.getWatchableObjectByte(16);
        if (par1) {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 | 1)));
        } else {
            this.dataWatcher.updateObject(16, (Object)((byte)(var2 & 0xFFFFFFFE)));
        }
    }

    public boolean getIsCritical() {
        byte var1 = this.dataWatcher.getWatchableObjectByte(16);
        return (var1 & 1) != 0;
    }

    public void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.worldObj.createExplosion((Entity)this.shootingEntity, this.posX, this.posY, this.posZ, 0.1f, true);
            this.setDead();
        }
    }

    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity), 1.0f);
            this.setDead();
        } else {
            if (mop instanceof EntityLivingBase) {
                ((EntityLivingBase)mop).addPotionEffect(new PotionEffect(Potion.weakness.id, 60, 2));
            }
            this.doDamage(this.projectileDamage, mop);
            this.worldObj.createExplosion((Entity)this.shootingEntity, this.posX, this.posY, this.posZ, 0.1f, true);
        }
        this.spawnHitParticles("magicCrit", 8);
        this.setDead();
    }

    private int d6() {
        return this.rand.nextInt(6) + 1;
    }

    protected void spawnHitParticles(String string, int i) {
        for (int particles = 0; particles < i; ++particles) {
            this.worldObj.spawnParticle(string, this.posX, this.posY - (double)(string == "portal" ? 1 : 0), this.posZ, this.gaussian(this.motionX), this.gaussian(this.motionY), this.gaussian(this.motionZ));
        }
    }

    protected void doDamage(int i, Entity mop) {
        mop.attackEntityFrom(this.getDamageSource(), (float)i);
    }

    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    public double smallGauss(double d) {
        return ((double)this.worldObj.rand.nextFloat() - 0.5) * d;
    }

    public double gaussian(double d) {
        return d + d * (((double)this.rand.nextFloat() - 0.5) / 4.0);
    }

    private int getRicochetMax() {
        return 0;
    }

    public Entity getThrower() {
        return this.shootingEntity;
    }

    public void setThrower(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.shootingEntity = (EntityLivingBase)entity;
        }
    }
}

