/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.entity.projectile.EntityEnergyBazookaSecondaryProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntityEnergyBazookaMainProjectile
extends EnergyBlastProjectile {
    public EntityEnergyBazookaMainProjectile(World par1World) {
        super(par1World);
    }

    public EntityEnergyBazookaMainProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public EntityEnergyBazookaMainProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage) {
        super(par1World, par2EntityPlayer, damage);
    }

    public EntityEnergyBazookaMainProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        super(par1World, par2EntityPlayer, damage, maxTicksInAir, posX, posY, posZ, rotationYaw, rotationPitch);
    }

    public EntityEnergyBazookaMainProjectile(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir) {
        super(par1World, par2EntityLivingBase, par3EntityLivingBase, par4, par5, damage, maxTicksInAir);
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            this.worldObj.createExplosion((Entity)this.shootingEntity, this.posX, this.posY, this.posZ, 5.0f, false);
            this.spawnSecondaryProjectiles();
        }
        this.setDead();
    }

    @Override
    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity), 1.0f);
            this.setDead();
        } else {
            if (mop instanceof EntityLivingBase) {
                this.spawnSecondaryProjectiles();
            }
            this.worldObj.createExplosion((Entity)this.shootingEntity, this.posX, this.posY, this.posZ, 5.0f, false);
        }
        this.spawnHitParticles("magicCrit", 8);
        this.setDead();
    }

    public void spawnSecondaryProjectiles() {
        for (int i = 0; i < 20; ++i) {
            EntityEnergyBazookaSecondaryProjectile secProj = new EntityEnergyBazookaSecondaryProjectile(this.worldObj, this.posX, this.posY, this.posZ, 15);
            secProj.shootingEntity = this.shootingEntity;
            float xVel = this.rand.nextFloat() - this.rand.nextFloat();
            float yVel = this.rand.nextFloat() - this.rand.nextFloat();
            float zVel = this.rand.nextFloat() - this.rand.nextFloat();
            float wantedVel = 0.5f;
            secProj.motionX = xVel * wantedVel;
            secProj.motionY = yVel * wantedVel;
            secProj.motionZ = zVel * wantedVel;
            this.worldObj.spawnEntityInWorld((Entity)secProj);
        }
    }
}

