/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class HolyProjectile
extends EnergyBlastProjectile {
    public HolyProjectile(World par1World) {
        super(par1World);
    }

    public HolyProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public HolyProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage) {
        super(par1World, par2EntityPlayer, damage);
    }

    public HolyProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        super(par1World, par2EntityPlayer, damage, maxTicksInAir, posX, posY, posZ, rotationYaw, rotationPitch);
    }

    public HolyProjectile(World par1World, EntityLivingBase par2EntityLivingBase, EntityLivingBase par3EntityLivingBase, float par4, float par5, int damage, int maxTicksInAir) {
        super(par1World, par2EntityLivingBase, par3EntityLivingBase, par4, par5, damage, maxTicksInAir);
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK) {
            // empty if block
        }
        this.setDead();
    }

    @Override
    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.shootingEntity.attackEntityFrom(DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity), 1.0f);
            this.setDead();
        } else if (mop instanceof EntityLivingBase) {
            if (((EntityLivingBase)mop).isEntityUndead()) {
                this.doDamage(this.projectileDamage * 2, mop);
            } else {
                this.doDamage(this.projectileDamage, mop);
            }
        }
        if (this.worldObj.isAirBlock((int)this.posX, (int)this.posY, (int)this.posZ)) {
            // empty if block
        }
        this.spawnHitParticles("magicCrit", 8);
        this.setDead();
    }

    @Override
    public void doFiringParticles() {
        SpellHelper.sendParticleToAllAround(this.worldObj, this.posX, this.posY, this.posZ, 30, this.worldObj.provider.dimensionId, "mobSpellAmbient", this.posX + this.smallGauss(0.1), this.posY + this.smallGauss(0.1), this.posZ + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        SpellHelper.sendParticleToAllAround(this.worldObj, this.posX, this.posY, this.posZ, 30, this.worldObj.provider.dimensionId, "mobSpell", this.posX, this.posY, this.posZ, 1.0, 1.0, 1.0);
    }
}

