/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class LightningBoltProjectile
extends EnergyBlastProjectile {
    private boolean causeLightning;

    public LightningBoltProjectile(World par1World) {
        super(par1World);
    }

    public LightningBoltProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
    }

    public LightningBoltProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, boolean flag) {
        super(par1World, par2EntityPlayer, damage);
        this.causeLightning = flag;
    }

    public LightningBoltProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch, boolean flag) {
        super(par1World, par2EntityPlayer, damage, maxTicksInAir, posX, posY, posZ, rotationYaw, rotationPitch);
        this.causeLightning = flag;
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && this.causeLightning) {
            this.worldObj.addWeatherEffect((Entity)new EntityLightningBolt(this.worldObj, this.posX, this.posY, this.posZ));
        }
        this.setDead();
    }

    @Override
    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.setDead();
        } else if (mop instanceof EntityLivingBase) {
            if (this.causeLightning) {
                this.worldObj.addWeatherEffect((Entity)new EntityLightningBolt(this.worldObj, ((EntityLivingBase)mop).posX, ((EntityLivingBase)mop).posY, ((EntityLivingBase)mop).posZ));
            } else {
                this.doDamage(this.projectileDamage, mop);
            }
        }
        this.spawnHitParticles("magicCrit", 8);
        this.setDead();
    }

    @Override
    public void doFiringParticles() {
        SpellHelper.sendParticleToAllAround(this.worldObj, this.posX, this.posY, this.posZ, 30, this.worldObj.provider.dimensionId, "mobSpellAmbient", this.posX + this.smallGauss(0.1), this.posY + this.smallGauss(0.1), this.posZ + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        SpellHelper.sendParticleToAllAround(this.worldObj, this.posX, this.posY, this.posZ, 30, this.worldObj.provider.dimensionId, "mobSpell", this.posX, this.posY, this.posZ, 1.0, 1.0, 1.0);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("causeLightning", this.causeLightning);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.causeLightning = par1NBTTagCompound.getBoolean("causeLightning");
    }
}

