/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.entity.projectile;

import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.spell.simple.SpellTeleport;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class TeleportProjectile
extends EnergyBlastProjectile {
    private boolean isEntityTeleport;

    public TeleportProjectile(World par1World) {
        super(par1World);
        this.motionX *= 3.0;
        this.motionY *= 3.0;
        this.motionZ *= 3.0;
    }

    public TeleportProjectile(World par1World, double par2, double par4, double par6) {
        super(par1World, par2, par4, par6);
        this.motionX *= 3.0;
        this.motionY *= 3.0;
        this.motionZ *= 3.0;
    }

    public TeleportProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, boolean flag) {
        super(par1World, par2EntityPlayer, damage);
        this.isEntityTeleport = flag;
        this.motionX *= 3.0;
        this.motionY *= 3.0;
        this.motionZ *= 3.0;
    }

    public TeleportProjectile(World par1World, EntityLivingBase par2EntityPlayer, int damage, int maxTicksInAir, double posX, double posY, double posZ, float rotationYaw, float rotationPitch, boolean flag) {
        super(par1World, par2EntityPlayer, damage, maxTicksInAir, posX, posY, posZ, rotationYaw, rotationPitch);
        this.isEntityTeleport = flag;
        this.motionX *= 3.0;
        this.motionY *= 3.0;
        this.motionZ *= 3.0;
    }

    @Override
    public DamageSource getDamageSource() {
        return DamageSource.causeMobDamage((EntityLivingBase)this.shootingEntity);
    }

    @Override
    public void onImpact(MovingObjectPosition mop) {
        if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.ENTITY && mop.entityHit != null) {
            if (mop.entityHit == this.shootingEntity) {
                return;
            }
            this.onImpact(mop.entityHit);
        } else if (mop.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && this.isEntityTeleport && this.shootingEntity != null && this.shootingEntity instanceof EntityPlayerMP) {
            EnderTeleportEvent event;
            EntityPlayerMP entityplayermp = (EntityPlayerMP)this.shootingEntity;
            if (entityplayermp.worldObj == this.worldObj && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)entityplayermp, this.posX, this.posY, this.posZ, 5.0f)))) {
                if (this.shootingEntity.isRiding()) {
                    this.shootingEntity.mountEntity((Entity)null);
                }
                this.shootingEntity.setPositionAndUpdate(event.targetX, event.targetY, event.targetZ);
            }
        }
        this.setDead();
    }

    @Override
    public void onImpact(Entity mop) {
        if (mop == this.shootingEntity && this.ticksInAir > 3) {
            this.setDead();
        } else if (mop instanceof EntityLivingBase) {
            if (this.isEntityTeleport) {
                if (this.shootingEntity != null && this.shootingEntity instanceof EntityPlayerMP) {
                    EnderTeleportEvent event;
                    EntityPlayerMP entityplayermp = (EntityPlayerMP)this.shootingEntity;
                    if (entityplayermp.worldObj == this.worldObj && !MinecraftForge.EVENT_BUS.post((Event)(event = new EnderTeleportEvent((EntityLivingBase)entityplayermp, this.posX, this.posY, this.posZ, 5.0f)))) {
                        if (this.shootingEntity.isRiding()) {
                            this.shootingEntity.mountEntity((Entity)null);
                        }
                        this.shootingEntity.setPositionAndUpdate(event.targetX, event.targetY, event.targetZ);
                    }
                }
            } else {
                SpellTeleport.teleportRandomly((EntityLivingBase)mop, 64.0);
            }
        }
        this.spawnHitParticles("magicCrit", 8);
        this.setDead();
    }

    @Override
    public void doFiringParticles() {
        SpellHelper.sendParticleToAllAround(this.worldObj, this.posX, this.posY, this.posZ, 30, this.worldObj.provider.dimensionId, "mobSpellAmbient", this.posX + this.smallGauss(0.1), this.posY + this.smallGauss(0.1), this.posZ + this.smallGauss(0.1), 0.5, 0.5, 0.5);
        SpellHelper.sendParticleToAllAround(this.worldObj, this.posX, this.posY, this.posZ, 30, this.worldObj.provider.dimensionId, "portal", this.posX, this.posY, this.posZ, -this.motionX, -this.motionY, -this.motionZ);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound par1NBTTagCompound) {
        super.writeEntityToNBT(par1NBTTagCompound);
        par1NBTTagCompound.setBoolean("isEntityTeleport", this.isEntityTeleport);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound par1NBTTagCompound) {
        super.readEntityFromNBT(par1NBTTagCompound);
        this.isEntityTeleport = par1NBTTagCompound.getBoolean("isEntityTeleport");
    }
}

