/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.harvest;

import WayofTime.alchemicalWizardry.api.harvest.IHarvestHandler;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class GenericItemStackHarvestHandler
implements IHarvestHandler {
    public Block harvestBlock;
    public int harvestMeta;
    public ItemStack harvestItem;
    public IPlantable harvestSeed;

    public GenericItemStackHarvestHandler(Block block, int meta, ItemStack seed) {
        this.harvestBlock = block;
        this.harvestMeta = meta;
        this.harvestItem = seed;
        if (seed.getItem() instanceof IPlantable) {
            this.harvestSeed = (IPlantable)seed.getItem();
        }
    }

    public boolean canHandleBlock(Block block) {
        return block == this.harvestBlock;
    }

    public int getHarvestMeta(Block block) {
        return this.harvestMeta;
    }

    @Override
    public boolean harvestAndPlant(World world, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        if (!this.canHandleBlock(block) || meta != this.getHarvestMeta(block)) {
            return false;
        }
        IPlantable seed = this.getSeedItem(block);
        if (seed == null) {
            world.func_147480_a(xCoord, yCoord, zCoord, true);
            return true;
        }
        int fortune = 0;
        ArrayList list = block.getDrops(world, xCoord, yCoord, zCoord, meta, fortune);
        boolean foundAndRemovedSeed = false;
        for (ItemStack stack : list) {
            int itemSize;
            if (stack == null || !this.harvestItem.isItemEqual(stack) || (itemSize = stack.stackSize--) < 1) continue;
            if (itemSize == 1) {
                list.remove(stack);
            }
            foundAndRemovedSeed = true;
            break;
        }
        if (foundAndRemovedSeed) {
            int plantMeta = seed.getPlantMetadata((IBlockAccess)world, xCoord, yCoord, zCoord);
            Block plantBlock = seed.getPlant((IBlockAccess)world, xCoord, yCoord, zCoord);
            world.func_147480_a(xCoord, yCoord, zCoord, false);
            world.setBlock(xCoord, yCoord, zCoord, plantBlock, plantMeta, 3);
            for (ItemStack stack : list) {
                EntityItem itemEnt = new EntityItem(world, (double)xCoord, (double)yCoord, (double)zCoord, stack);
                world.spawnEntityInWorld((Entity)itemEnt);
            }
        }
        return false;
    }

    public IPlantable getSeedItem(Block block) {
        return this.harvestSeed;
    }
}

