/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.harvest;

import WayofTime.alchemicalWizardry.api.harvest.IHarvestHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class GenericSeededHarvestHandler
implements IHarvestHandler {
    public Block harvestBlock;
    public int harvestMeta;
    public IPlantable harvestSeed;

    public GenericSeededHarvestHandler(String block, int meta, String seed) {
        this.harvestBlock = GenericSeededHarvestHandler.getBlockForString(block);
        this.harvestMeta = meta;
        Item testSeed = GenericSeededHarvestHandler.getItemForString(seed);
        this.harvestSeed = testSeed instanceof IPlantable ? (IPlantable)testSeed : null;
    }

    public boolean isHarvesterValid() {
        return this.harvestBlock != null && this.harvestSeed != null;
    }

    public static Block getBlockForString(String str) {
        String[] parts = str.split(":");
        String modId = parts[0];
        String name = parts[1];
        return GameRegistry.findBlock((String)modId, (String)name);
    }

    public static Item getItemForString(String str) {
        String[] parts = str.split(":");
        String modId = parts[0];
        String name = parts[1];
        return GameRegistry.findItem((String)modId, (String)name);
    }

    public boolean canHandleBlock(Block block) {
        return block == this.harvestBlock;
    }

    public int getHarvestMeta(Block block) {
        return this.harvestMeta;
    }

    @Override
    public boolean harvestAndPlant(World world, int xCoord, int yCoord, int zCoord, Block block, int meta) {
        if (!this.canHandleBlock(block) || meta != this.getHarvestMeta(block)) {
            return false;
        }
        IPlantable seed = this.getSeedItem(block);
        if (seed == null) {
            world.func_147480_a(xCoord, yCoord, zCoord, true);
            return true;
        }
        int fortune = 0;
        ArrayList list = block.getDrops(world, xCoord, yCoord, zCoord, meta, fortune);
        boolean foundAndRemovedSeed = false;
        for (ItemStack stack : list) {
            int itemSize;
            Item item;
            if (stack == null || (item = stack.getItem()) != seed) continue;
            if ((itemSize = stack.stackSize--) > 1) {
                foundAndRemovedSeed = true;
                break;
            }
            if (itemSize != 1) continue;
            list.remove(stack);
            foundAndRemovedSeed = true;
            break;
        }
        if (foundAndRemovedSeed) {
            int plantMeta = seed.getPlantMetadata((IBlockAccess)world, xCoord, yCoord, zCoord);
            Block plantBlock = seed.getPlant((IBlockAccess)world, xCoord, yCoord, zCoord);
            world.func_147480_a(xCoord, yCoord, zCoord, false);
            world.setBlock(xCoord, yCoord, zCoord, plantBlock, plantMeta, 3);
            for (ItemStack stack : list) {
                EntityItem itemEnt = new EntityItem(world, (double)xCoord, (double)yCoord, (double)zCoord, stack);
                world.spawnEntityInWorld((Entity)itemEnt);
            }
        }
        return false;
    }

    public IPlantable getSeedItem(Block block) {
        return this.harvestSeed;
    }
}

