/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.event.SacrificeKnifeUsedEvent;
import WayofTime.alchemicalWizardry.api.sacrifice.PlayerSacrificeHandler;
import WayofTime.alchemicalWizardry.api.tile.IBloodAltar;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.FakePlayer;

public class CreativeDagger
extends Item {
    public CreativeDagger() {
        this.setTextureName("AlchemicalWizardry:SacrificialDagger");
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setFull3D();
    }

    public ItemStack onItemRightClick(ItemStack stack, World world, EntityPlayer player) {
        if (this.canUseForSacrifice(stack)) {
            player.setItemInUse(stack, this.getMaxItemUseDuration(stack));
            return stack;
        }
        if (!player.capabilities.isCreativeMode) {
            SacrificeKnifeUsedEvent evt = new SacrificeKnifeUsedEvent(player, true, true, 2);
            if (MinecraftForge.EVENT_BUS.post((Event)evt)) {
                return stack;
            }
            if (evt.shouldDrainHealth) {
                player.setHealth(player.getHealth() - 2.0f);
            }
            if (!evt.shouldFillAltar) {
                return stack;
            }
        }
        if (player instanceof FakePlayer) {
            return stack;
        }
        double posX = player.posX;
        double posY = player.posY;
        double posZ = player.posZ;
        world.playSoundEffect((double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
        float f = 1.0f;
        float f1 = f * 0.6f + 0.4f;
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        for (int l = 0; l < 8; ++l) {
            world.spawnParticle("reddust", posX + Math.random() - Math.random(), posY + Math.random() - Math.random(), posZ + Math.random() - Math.random(), (double)f1, (double)f2, (double)f3);
        }
        if (!world.isRemote && SpellHelper.isFakePlayer(world, player)) {
            return stack;
        }
        this.findAndFillAltar(world, player, Integer.MAX_VALUE);
        return stack;
    }

    public void findAndFillAltar(World world, EntityPlayer player, int amount) {
        int posZ;
        int posY;
        int posX = (int)Math.round(player.posX - 0.5);
        IBloodAltar altarEntity = this.getAltar(world, posX, posY = (int)player.posY, posZ = (int)Math.round(player.posZ - 0.5));
        if (altarEntity == null) {
            return;
        }
        altarEntity.sacrificialDaggerCall(amount, false);
        altarEntity.startCycle();
    }

    public IBloodAltar getAltar(World world, int x, int y, int z) {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k <= 1; ++k) {
                    TileEntity tileEntity = world.getTileEntity(i + x, k + y, j + z);
                    if (!(tileEntity instanceof IBloodAltar)) continue;
                    return (IBloodAltar)tileEntity;
                }
            }
        }
        return null;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (!world.isRemote && entity instanceof EntityPlayer) {
            this.setUseForSacrifice(stack, this.isPlayerPreparedForSacrifice(world, (EntityPlayer)entity));
        }
    }

    public boolean isPlayerPreparedForSacrifice(World world, EntityPlayer player) {
        return !world.isRemote && PlayerSacrificeHandler.getPlayerIncense(player) > 0.0f;
    }

    public boolean canUseForSacrifice(ItemStack stack) {
        NBTTagCompound tag = stack.getTagCompound();
        return tag != null && tag.getBoolean("sacrifice");
    }

    public void setUseForSacrifice(ItemStack stack, boolean sacrifice) {
        NBTTagCompound tag = stack.getTagCompound();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.setTagCompound(tag);
        }
        tag.setBoolean("sacrifice", sacrifice);
    }
}

