/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.entity.projectile.EnergyBlastProjectile;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class EnergyBlast
extends EnergyItems {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int damage;

    public EnergyBlast() {
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setUnlocalizedName("energyBlaster");
        this.setFull3D();
        this.setMaxDamage(250);
        this.setEnergyUsed(150);
        this.damage = 12;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:EnergyBlaster_activated");
        this.activeIcon = iconRegister.registerIcon("AlchemicalWizardry:EnergyBlaster_activated");
        this.passiveIcon = iconRegister.registerIcon("AlchemicalWizardry:SheathedItem");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if ((tag = stack.getTagCompound()).getBoolean("isActive")) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        int maxDelay = 15;
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            this.setActivated(par1ItemStack, !this.getActivated(par1ItemStack));
            par1ItemStack.getTagCompound().setInteger("worldTimeDelay", (int)(par2World.getWorldTime() - 1L) % 100);
            return par1ItemStack;
        }
        if (!this.getActivated(par1ItemStack)) {
            return par1ItemStack;
        }
        if (this.getDelay(par1ItemStack) > 0) {
            return par1ItemStack;
        }
        if (!par3EntityPlayer.capabilities.isCreativeMode && !EnergyBlast.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            return par1ItemStack;
        }
        par2World.playSoundAtEntity((Entity)par3EntityPlayer, "random.bow", 0.5f, 0.4f / (itemRand.nextFloat() * 0.4f + 0.8f));
        if (!par2World.isRemote) {
            par2World.spawnEntityInWorld((Entity)new EnergyBlastProjectile(par2World, (EntityLivingBase)par3EntityPlayer, this.damage));
            this.setDelay(par1ItemStack, 15);
        }
        return par1ItemStack;
    }

    public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        int delay = this.getDelay(par1ItemStack);
        if (!par2World.isRemote && delay > 0) {
            this.setDelay(par1ItemStack, delay - 1);
        }
        if (par2World.getWorldTime() % 100L == (long)par1ItemStack.getTagCompound().getInteger("worldTimeDelay") && par1ItemStack.getTagCompound().getBoolean("isActive") && !par3EntityPlayer.capabilities.isCreativeMode && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, 50)) {
            this.setActivated(par1ItemStack, false);
        }
        par1ItemStack.setItemDamage(0);
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.energyblast.desc1"));
        par3List.add(StatCollector.translateToLocal((String)"tooltip.energyblast.desc2"));
        par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.damage") + " " + this.damage);
        if (par1ItemStack.getTagCompound() != null) {
            if (par1ItemStack.getTagCompound().getBoolean("isActive")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.deactivated"));
            }
            if (!par1ItemStack.getTagCompound().getString("ownerName").equals("")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
            }
        }
    }

    public void setActivated(ItemStack par1ItemStack, boolean newActivated) {
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (itemTag == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        itemTag.setBoolean("isActive", newActivated);
    }

    public boolean getActivated(ItemStack par1ItemStack) {
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (itemTag == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        return itemTag.getBoolean("isActive");
    }

    public void setDelay(ItemStack par1ItemStack, int newDelay) {
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (itemTag == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        itemTag.setInteger("delay", newDelay);
    }

    public int getDelay(ItemStack par1ItemStack) {
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (itemTag == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        return itemTag.getInteger("delay");
    }
}

