/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.alchemy.AlchemyRecipeRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemAlchemyBase
extends Item {
    private static final String[] ITEM_NAMES = new String[]{"Offensa", "Praesidium", "OrbisTerrae", "StrengthenedCatalyst", "ConcentratedCatalyst", "FracturedBone", "Virtus", "Reductus", "Potentia"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] icons;

    public ItemAlchemyBase() {
        this.maxStackSize = 64;
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.hasSubtypes = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.icons = new IIcon[ITEM_NAMES.length];
        for (int i = 0; i < ITEM_NAMES.length; ++i) {
            this.icons[i] = iconRegister.registerIcon("AlchemicalWizardry:baseAlchemyItem" + ITEM_NAMES[i]);
        }
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.usedinalchemy"));
        if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
            ItemStack[] recipe = AlchemyRecipeRegistry.getRecipeForItemStack(par1ItemStack);
            if (recipe != null) {
                par3List.add(EnumChatFormatting.BLUE + StatCollector.translateToLocal((String)"tooltip.alchemy.recipe"));
                for (ItemStack item : recipe) {
                    if (item == null) continue;
                    par3List.add("" + item.getDisplayName());
                }
            }
        } else {
            par3List.add("-" + StatCollector.translateToLocal((String)"tooltip.alchemy.press") + " " + EnumChatFormatting.BLUE + StatCollector.translateToLocal((String)"tooltip.alchemy.shift") + EnumChatFormatting.GRAY + " " + StatCollector.translateToLocal((String)"tooltip.alchemy.forrecipe") + "-");
        }
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = MathHelper.clamp_int((int)itemStack.getItemDamage(), (int)0, (int)(ITEM_NAMES.length - 1));
        return "item.bloodMagicAlchemyItem." + ITEM_NAMES[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int meta) {
        int j = MathHelper.clamp_int((int)meta, (int)0, (int)(ITEM_NAMES.length - 1));
        return this.icons[j];
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item id, CreativeTabs creativeTab, List list) {
        for (int meta = 0; meta < ITEM_NAMES.length; ++meta) {
            list.add(new ItemStack(id, 1, meta));
        }
    }
}

