/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.items.interfaces.IBindable;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;

public class ItemDiabloKey
extends EnergyItems {
    public ItemDiabloKey() {
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.setEnergyUsed(1000);
        this.hasSubtypes = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:DiabloKey");
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.diablokey.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
        }
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        ItemStack[] inv;
        World world = par3EntityPlayer.worldObj;
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer instanceof FakePlayer || par3EntityPlayer instanceof EntityPlayerMP) {
            return par1ItemStack;
        }
        if (world != null) {
            double posX = par3EntityPlayer.posX;
            double posY = par3EntityPlayer.posY;
            double posZ = par3EntityPlayer.posZ;
            world.playSoundEffect((double)((float)posX + 0.5f), (double)((float)posY + 0.5f), (double)((float)posZ + 0.5f), "random.fizz", 0.5f, 2.6f + (world.rand.nextFloat() - world.rand.nextFloat()) * 0.8f);
            SpellHelper.sendIndexedParticleToAllAround(world, posX, posY, posZ, 20, world.provider.dimensionId, 4, posX, posY, posZ);
        }
        if (!par3EntityPlayer.worldObj.isRemote && !par3EntityPlayer.getClass().equals(EntityPlayerMP.class)) {
            return par1ItemStack;
        }
        if (par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        NBTTagCompound itemTag = par1ItemStack.getTagCompound();
        if (itemTag == null || itemTag.getString("ownerName").equals("")) {
            return par1ItemStack;
        }
        String ownerName = itemTag.getString("ownerName");
        for (ItemStack itemStack : inv = par3EntityPlayer.inventory.mainInventory) {
            Item item;
            if (itemStack == null || (item = itemStack.getItem()) instanceof ItemDiabloKey || !(item instanceof IBindable)) continue;
            EnergyItems.checkAndSetItemOwner(itemStack, ownerName);
        }
        return par1ItemStack;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item id, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack(ModItems.itemKeyOfDiablo));
        ItemStack boundKey = new ItemStack(ModItems.itemKeyOfDiablo);
        EnergyItems.checkAndSetItemOwner(boundKey, "Server-wide Soul Network");
        list.add(boundKey);
    }
}

