/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.ModBlocks;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.items.interfaces.IRitualDiviner;
import WayofTime.alchemicalWizardry.api.rituals.IMasterRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.IRitualStone;
import WayofTime.alchemicalWizardry.api.rituals.RitualComponent;
import WayofTime.alchemicalWizardry.api.rituals.Rituals;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.tileEntity.TEMasterStone;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class ItemRitualDiviner
extends EnergyItems
implements IRitualDiviner {
    private int maxMetaData;

    public ItemRitualDiviner() {
        this.maxStackSize = 1;
        this.setEnergyUsed(100);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.maxMetaData = 4;
        this.hasSubtypes = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:RitualDiviner");
    }

    public void addInformation(ItemStack stack, EntityPlayer player, List par3List, boolean x) {
        boolean sneaking;
        par3List.add(StatCollector.translateToLocal((String)"tooltip.ritualdiviner.desc"));
        if (this.getMaxRuneDisplacement(stack) == 1) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.ritualdiviner.canplace"));
        } else if (this.getMaxRuneDisplacement(stack) >= 2) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.ritualdiviner.canplacedawn"));
        } else {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.ritualdiviner.cannotplace"));
        }
        par3List.add(StatCollector.translateToLocal((String)"tooltip.ritualdiviner.ritualtunedto") + " " + this.getNameForDirection(this.getDirection(stack)));
        boolean bl = sneaking = Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42);
        if (sneaking) {
            if (stack.getTagCompound() != null) {
                String ritualID = this.getCurrentRitual(stack);
                par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + stack.getTagCompound().getString("ownerName"));
                par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.ritualid") + " " + ritualID);
                List<RitualComponent> ritualList = Rituals.getRitualList(this.getCurrentRitual(stack));
                if (ritualList == null) {
                    return;
                }
                int blankStones = 0;
                int airStones = 0;
                int waterStones = 0;
                int fireStones = 0;
                int earthStones = 0;
                int duskStones = 0;
                int dawnStones = 0;
                for (RitualComponent rc : ritualList) {
                    switch (rc.getStoneType()) {
                        case 0: {
                            ++blankStones;
                            break;
                        }
                        case 4: {
                            ++airStones;
                            break;
                        }
                        case 1: {
                            ++waterStones;
                            break;
                        }
                        case 2: {
                            ++fireStones;
                            break;
                        }
                        case 3: {
                            ++earthStones;
                            break;
                        }
                        case 5: {
                            ++duskStones;
                            break;
                        }
                        case 6: {
                            ++dawnStones;
                        }
                    }
                }
                int totalStones = blankStones + airStones + waterStones + fireStones + earthStones + duskStones + dawnStones;
                par3List.add(EnumChatFormatting.WHITE + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.blankstones") + " " + blankStones);
                par3List.add(EnumChatFormatting.AQUA + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.airstones") + " " + airStones);
                par3List.add(EnumChatFormatting.BLUE + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.waterstones") + " " + waterStones);
                par3List.add(EnumChatFormatting.RED + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.firestones") + " " + fireStones);
                par3List.add(EnumChatFormatting.DARK_GREEN + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.earthstones") + " " + earthStones);
                par3List.add(EnumChatFormatting.DARK_PURPLE + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.duskstones") + " " + duskStones);
                par3List.add(EnumChatFormatting.GOLD + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.dawnstones") + " " + dawnStones);
                par3List.add(EnumChatFormatting.UNDERLINE + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.totalStones") + " " + totalStones);
            }
        } else {
            par3List.add(EnumChatFormatting.AQUA + "-" + StatCollector.translateToLocal((String)"tooltip.ritualdiviner.moreinfo") + "-");
        }
    }

    public String getItemStackDisplayName(ItemStack stack) {
        if (stack.getTagCompound() != null) {
            String ritualID = this.getCurrentRitual(stack);
            if (ritualID.equals("")) {
                return super.getItemStackDisplayName(stack);
            }
            return "Ritual: " + Rituals.getNameOfRitual(ritualID);
        }
        return super.getItemStackDisplayName(stack);
    }

    public boolean onItemUse(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int par7, float par8, float par9, float par10) {
        if (!EnergyItems.checkAndSetItemOwner(stack, player)) {
            return false;
        }
        if (this.placeRitualStoneAtMasterStone(stack, player, world, x, y, z)) {
            this.setStoredLocation(stack, new Int3(x, y, z));
            return true;
        }
        if (!(world.getBlock(x, y, z) instanceof IRitualStone || world.getBlock(x, y, z) instanceof IMasterRitualStone || player.isSneaking())) {
            if (world.isRemote) {
                return false;
            }
            this.cycleDirection(stack);
            player.addChatComponentMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"tooltip.ritualdiviner.ritualtunedto") + " " + this.getNameForDirection(this.getDirection(stack))));
            return true;
        }
        return false;
    }

    public boolean placeRitualStoneAtMasterStone(ItemStack stack, EntityPlayer player, World world, int x, int y, int z) {
        int direction = this.getDirection(stack);
        ItemStack[] playerInventory = player.inventory.mainInventory;
        TileEntity tileEntity = world.getTileEntity(x, y, z);
        if (tileEntity instanceof TEMasterStone) {
            List<RitualComponent> ritualList = Rituals.getRitualList(this.getCurrentRitual(stack));
            if (ritualList == null) {
                return false;
            }
            int playerInvRitualStoneLocation = -1;
            for (int i = 0; i < playerInventory.length; ++i) {
                if (playerInventory[i] == null || !new ItemStack(ModBlocks.ritualStone).isItemEqual(playerInventory[i])) continue;
                playerInvRitualStoneLocation = i;
                break;
            }
            for (RitualComponent rc : ritualList) {
                if (world.isAirBlock(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction))) {
                    if (playerInvRitualStoneLocation < 0 && !player.capabilities.isCreativeMode) continue;
                    if (rc.getStoneType() > this.maxMetaData + this.getMaxRuneDisplacement(stack)) {
                        world.playAuxSFX(200, x, y + 1, z, 0);
                        return true;
                    }
                    if (!player.capabilities.isCreativeMode) {
                        player.inventory.decrStackSize(playerInvRitualStoneLocation, 1);
                    }
                    if (EnergyItems.syphonBatteries(stack, player, this.getEnergyUsed())) {
                        world.setBlock(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction), ModBlocks.ritualStone, rc.getStoneType(), 3);
                        if (world.isRemote) {
                            world.playAuxSFX(2005, x, y + 1, z, 0);
                            return true;
                        }
                    }
                    return true;
                }
                Block block = world.getBlock(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction));
                if (block == ModBlocks.ritualStone) {
                    int metadata = world.getBlockMetadata(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction));
                    if (metadata == rc.getStoneType() || !EnergyItems.syphonBatteries(stack, player, this.getEnergyUsed())) continue;
                    if (rc.getStoneType() > this.maxMetaData + this.getMaxRuneDisplacement(stack)) {
                        world.playAuxSFX(200, x, y + 1, z, 0);
                        return true;
                    }
                    world.setBlockMetadataWithNotify(x + rc.getX(direction), y + rc.getY(), z + rc.getZ(direction), rc.getStoneType(), 3);
                    return true;
                }
                world.playAuxSFX(0, x, y + 1, z, 0);
                return true;
            }
        }
        return false;
    }

    public void onUpdate(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (entity instanceof EntityPlayer && this.hasStoredLocation(stack) && world.getWorldTime() % 5L == 0L) {
            Int3 loc = this.getStoredLocation(stack);
            int x = loc.xCoord;
            int y = loc.yCoord;
            int z = loc.zCoord;
            if (!this.placeRitualStoneAtMasterStone(stack, (EntityPlayer)entity, world, x, y, z)) {
                this.voidStoredLocation(stack);
            }
        }
    }

    public void setStoredLocation(ItemStack stack, Int3 location) {
        NBTTagCompound tag = stack.getTagCompound();
        if (tag == null) {
            tag = new NBTTagCompound();
            stack.setTagCompound(tag);
        }
        NBTTagCompound locTag = location.writeToNBT(new NBTTagCompound());
        locTag.setBoolean("isStored", true);
        tag.setTag("location", (NBTBase)locTag);
    }

    public void voidStoredLocation(ItemStack stack) {
        NBTTagCompound tag = stack.getTagCompound();
        if (tag == null || !tag.hasKey("location")) {
            this.setStoredLocation(stack, new Int3(0, 0, 0));
            return;
        }
        NBTTagCompound locTag = (NBTTagCompound)tag.getTag("location");
        if (locTag != null) {
            locTag.setBoolean("isStored", false);
        }
    }

    public Int3 getStoredLocation(ItemStack stack) {
        NBTTagCompound tag = stack.getTagCompound();
        if (tag == null || !tag.hasKey("location")) {
            return new Int3(0, 0, 0);
        }
        NBTTagCompound locTag = (NBTTagCompound)tag.getTag("location");
        return Int3.readFromNBT(locTag);
    }

    public boolean hasStoredLocation(ItemStack stack) {
        NBTTagCompound tag = stack.getTagCompound();
        if (tag == null || !tag.hasKey("location")) {
            return false;
        }
        NBTTagCompound locTag = (NBTTagCompound)tag.getTag("location");
        return locTag.getBoolean("isStored");
    }

    public ItemStack onItemRightClick(ItemStack stack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(stack, par3EntityPlayer) && par3EntityPlayer.isSneaking()) {
            this.rotateRituals(par2World, par3EntityPlayer, stack, true);
        }
        return stack;
    }

    public boolean onEntitySwing(EntityLivingBase entityLiving, ItemStack stack) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!EnergyItems.checkAndSetItemOwner(stack, player)) {
                return true;
            }
            if (!player.isSwingInProgress && player.isSneaking()) {
                this.rotateRituals(player.worldObj, player, stack, false);
            }
        }
        return false;
    }

    public void rotateRituals(World world, EntityPlayer player, ItemStack stack, boolean next) {
        this.voidStoredLocation(stack);
        String currentRitualID = this.getCurrentRitual(stack);
        this.setCurrentRitual(stack, next ? Rituals.getNextRitualKey(currentRitualID) : Rituals.getPreviousRitualKey(currentRitualID));
        if (world.isRemote) {
            ChatComponentText chatmessagecomponent = new ChatComponentText(StatCollector.translateToLocal((String)"message.ritual.currentritual") + " " + Rituals.getNameOfRitual(this.getCurrentRitual(stack)));
            player.addChatComponentMessage((IChatComponent)chatmessagecomponent);
        }
    }

    @Override
    public String getCurrentRitual(ItemStack stack) {
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        return stack.getTagCompound().getString("ritualID");
    }

    @Override
    public void setCurrentRitual(ItemStack stack, String ritualID) {
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        stack.getTagCompound().setString("ritualID", ritualID);
    }

    @Override
    public int getMaxRuneDisplacement(ItemStack stack) {
        return stack.getItemDamage();
    }

    @Override
    public void setMaxRuneDisplacement(ItemStack stack, int displacement) {
        stack.setItemDamage(displacement);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item id, CreativeTabs creativeTab, List list) {
        list.add(new ItemStack(id));
        ItemStack duskRitualDivinerStack = new ItemStack(id);
        this.setMaxRuneDisplacement(duskRitualDivinerStack, 1);
        list.add(duskRitualDivinerStack);
        ItemStack dawnRitualDivinerStack = new ItemStack(id);
        this.setMaxRuneDisplacement(dawnRitualDivinerStack, 2);
        list.add(dawnRitualDivinerStack);
    }

    @Override
    public int getDirection(ItemStack itemStack) {
        if (itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        return itemStack.getTagCompound().getInteger("direction");
    }

    @Override
    public void setDirection(ItemStack itemStack, int direction) {
        if (itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        itemStack.getTagCompound().setInteger("direction", direction);
    }

    @Override
    public int cycleDirection(ItemStack itemStack) {
        this.voidStoredLocation(itemStack);
        int direction = this.getDirection(itemStack);
        direction = direction < 4 ? Math.max(1, direction + 1) : 1;
        this.setDirection(itemStack, direction);
        return direction;
    }

    @Override
    public String getNameForDirection(int direction) {
        String dir = "";
        switch (direction) {
            case 0: 
            case 1: {
                dir = StatCollector.translateToLocal((String)"message.ritual.side.north");
                break;
            }
            case 2: {
                dir = StatCollector.translateToLocal((String)"message.ritual.side.east");
                break;
            }
            case 3: {
                dir = StatCollector.translateToLocal((String)"message.ritual.side.south");
                break;
            }
            case 4: {
                dir = StatCollector.translateToLocal((String)"message.ritual.side.west");
            }
        }
        return dir;
    }
}

