/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class TelepositionFocus
extends EnergyItems {
    private int focusLevel;

    public TelepositionFocus(int focusLevel) {
        this.setMaxStackSize(1);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
        this.focusLevel = focusLevel;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:TeleposerFocus");
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.telepositionfocus.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            NBTTagCompound itemTag = par1ItemStack.getTagCompound();
            if (!par1ItemStack.getTagCompound().getString("ownerName").equals("")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
            }
            par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.coords") + " " + itemTag.getInteger("xCoord") + ", " + itemTag.getInteger("yCoord") + ", " + itemTag.getInteger("zCoord"));
            par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.dimension") + " " + this.getDimensionID(par1ItemStack));
        }
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) && par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        return par1ItemStack;
    }

    public int getDimensionID(ItemStack itemStack) {
        if (itemStack.getTagCompound() == null) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        return itemStack.getTagCompound().getInteger("dimensionId");
    }

    public World getWorld(ItemStack itemStack) {
        return DimensionManager.getWorld((int)this.getDimensionID(itemStack));
    }

    public int xCoord(ItemStack itemStack) {
        if (itemStack.getTagCompound() != null) {
            return itemStack.getTagCompound().getInteger("xCoord");
        }
        return 0;
    }

    public int yCoord(ItemStack itemStack) {
        if (itemStack.getTagCompound() != null) {
            return itemStack.getTagCompound().getInteger("yCoord");
        }
        return 0;
    }

    public int zCoord(ItemStack itemStack) {
        if (itemStack.getTagCompound() != null) {
            return itemStack.getTagCompound().getInteger("zCoord");
        }
        return 0;
    }

    public int getFocusLevel() {
        return this.focusLevel;
    }
}

