/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.forestry;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IHiveFrame;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBloodFrame
extends EnergyItems
implements IHiveFrame {
    public ItemBloodFrame() {
        this.maxStackSize = 1;
        this.setMaxDamage(10);
        this.setEnergyUsed(1000);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.bloodframe.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:BloodFrame");
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        if (EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) && par1ItemStack.getItemDamage() > 0 && EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            par1ItemStack.setItemDamage(par1ItemStack.getItemDamage() - 1);
        }
        return par1ItemStack;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 1.0f;
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 1.0E-4f;
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return 0.0f;
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 1.0f;
    }

    public boolean isSealed() {
        return false;
    }

    public boolean isSelfLighted() {
        return false;
    }

    public boolean isSunlightSimulated() {
        return false;
    }

    public boolean isHellish() {
        return false;
    }

    public ItemStack frameUsed(IBeeHousing housing, ItemStack frame, IBee queen, int wear) {
        if (EnergyItems.canSyphonInContainer(frame, this.getEnergyUsed() * wear)) {
            EnergyItems.syphonWhileInContainer(frame, this.getEnergyUsed() * wear);
            return frame;
        }
        frame.setItemDamage(frame.getItemDamage() + wear);
        if (frame.getItemDamage() >= frame.getMaxDamage()) {
            return null;
        }
        return frame;
    }
}

