/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.routing;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.Int3;
import WayofTime.alchemicalWizardry.api.RoutingFocusLogic;
import WayofTime.alchemicalWizardry.api.RoutingFocusPosAndFacing;
import WayofTime.alchemicalWizardry.common.items.routing.ILimitedRoutingFocus;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class RoutingFocus
extends Item {
    public RoutingFocus() {
        this.maxStackSize = 1;
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    public RoutingFocusPosAndFacing getPosAndFacing(ItemStack itemStack) {
        return new RoutingFocusPosAndFacing(new Int3(this.xCoord(itemStack), this.yCoord(itemStack), this.zCoord(itemStack)), this.getSetDirection(itemStack));
    }

    public ForgeDirection getSetDirection(ItemStack itemStack) {
        if (!itemStack.hasTagCompound()) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.getTagCompound();
        return ForgeDirection.getOrientation((int)tag.getInteger("direction"));
    }

    public void setSetDirection(ItemStack itemStack, ForgeDirection dir) {
        if (!itemStack.hasTagCompound()) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.getTagCompound();
        tag.setInteger("direction", dir.ordinal());
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)this.getFocusDescription()));
        if (par1ItemStack.getTagCompound() != null) {
            NBTTagCompound itemTag = par1ItemStack.getTagCompound();
            par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.coords") + " " + itemTag.getInteger("xCoord") + ", " + itemTag.getInteger("yCoord") + ", " + itemTag.getInteger("zCoord"));
            par3List.add(StatCollector.translateToLocal((String)"tooltip.alchemy.direction") + " " + this.getSetDirection(par1ItemStack));
        }
    }

    public String getFocusDescription() {
        return "tooltip.routingFocus.desc";
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (world.isRemote) {
            return false;
        }
        TileEntity tile = world.getTileEntity(x, y, z);
        if (tile instanceof IInventory) {
            if (player.isSneaking() && this instanceof ILimitedRoutingFocus) {
                int pastAmount = ((ILimitedRoutingFocus)((Object)this)).getRoutingFocusLimit(stack);
                int amount = SpellHelper.getNumberOfItemsInInventory((IInventory)tile, ForgeDirection.getOrientation((int)side));
                if (amount != pastAmount) {
                    ((ILimitedRoutingFocus)((Object)this)).setRoutingFocusLimit(stack, amount);
                    player.addChatComponentMessage((IChatComponent)new ChatComponentText(StatCollector.translateToLocal((String)"message.routerfocus.limit") + amount));
                }
            }
            this.setCoordinates(stack, x, y, z);
            this.setSetDirection(stack, ForgeDirection.getOrientation((int)side));
            return true;
        }
        return true;
    }

    public void setCoordinates(ItemStack itemStack, int x, int y, int z) {
        if (!itemStack.hasTagCompound()) {
            itemStack.setTagCompound(new NBTTagCompound());
        }
        NBTTagCompound tag = itemStack.getTagCompound();
        tag.setInteger("xCoord", x);
        tag.setInteger("yCoord", y);
        tag.setInteger("zCoord", z);
    }

    public int xCoord(ItemStack itemStack) {
        if (itemStack.getTagCompound() != null) {
            return itemStack.getTagCompound().getInteger("xCoord");
        }
        return 0;
    }

    public int yCoord(ItemStack itemStack) {
        if (itemStack.getTagCompound() != null) {
            return itemStack.getTagCompound().getInteger("yCoord");
        }
        return 0;
    }

    public int zCoord(ItemStack itemStack) {
        if (itemStack.getTagCompound() != null) {
            return itemStack.getTagCompound().getInteger("zCoord");
        }
        return 0;
    }

    public RoutingFocusLogic getLogic(ItemStack itemStack) {
        return new RoutingFocusLogic();
    }
}

