/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.IHolding;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SigilOfMagnetism
extends EnergyItems
implements ArmourUpgrade,
IHolding,
ISigil {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int tickDelay = 300;

    public SigilOfMagnetism() {
        this.maxStackSize = 1;
        this.setEnergyUsed(AlchemicalWizardry.sigilMagnetismCost);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.sigilofmagnetism.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            if (par1ItemStack.getTagCompound().getBoolean("isActive")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.deactivated"));
            }
            par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:SigilOfMagnetism_deactivated");
        this.activeIcon = iconRegister.registerIcon("AlchemicalWizardry:SigilOfMagnetism_activated");
        this.passiveIcon = iconRegister.registerIcon("AlchemicalWizardry:SigilOfMagnetism_deactivated");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if ((tag = stack.getTagCompound()).getBoolean("isActive")) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        if (par1 == 1) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        NBTTagCompound tag;
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        tag.setBoolean("isActive", !(tag = par1ItemStack.getTagCompound()).getBoolean("isActive"));
        if (tag.getBoolean("isActive") && EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            par1ItemStack.setItemDamage(1);
            tag.setInteger("worldTimeDelay", (int)(par2World.getWorldTime() - 1L) % this.tickDelay);
        } else {
            par1ItemStack.setItemDamage(par1ItemStack.getMaxDamage());
        }
        return par1ItemStack;
    }

    public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        if (par1ItemStack.getTagCompound().getBoolean("isActive")) {
            if (par2World.getWorldTime() % (long)this.tickDelay == (long)par1ItemStack.getTagCompound().getInteger("worldTimeDelay") && !EnergyItems.syphonBatteries(par1ItemStack, (EntityPlayer)par3Entity, this.getEnergyUsed())) {
                par1ItemStack.getTagCompound().setBoolean("isActive", false);
            }
            int range = 5;
            int verticalRange = 5;
            float posX = Math.round(par3Entity.posX);
            float posY = (float)(par3Entity.posY - (double)par3Entity.getEyeHeight());
            float posZ = Math.round(par3Entity.posZ);
            List entities = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)(posX - 0.5f), (double)(posY - 0.5f), (double)(posZ - 0.5f), (double)(posX + 0.5f), (double)(posY + 0.5f), (double)(posZ + 0.5f)).expand((double)range, (double)verticalRange, (double)range));
            List xpOrbs = par3EntityPlayer.worldObj.getEntitiesWithinAABB(EntityXPOrb.class, AxisAlignedBB.getBoundingBox((double)(posX - 0.5f), (double)(posY - 0.5f), (double)(posZ - 0.5f), (double)(posX + 0.5f), (double)(posY + 0.5f), (double)(posZ + 0.5f)).expand((double)range, (double)verticalRange, (double)range));
            for (EntityItem entity : entities) {
                if (entity == null || par2World.isRemote) continue;
                entity.onCollideWithPlayer(par3EntityPlayer);
            }
            for (EntityXPOrb xpOrb : xpOrbs) {
                if (xpOrb == null || par2World.isRemote) continue;
                xpOrb.onCollideWithPlayer(par3EntityPlayer);
            }
        }
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
        int range = 5;
        int verticalRange = 5;
        float posX = Math.round(player.posX);
        float posY = (float)(player.posY - (double)player.getEyeHeight());
        float posZ = Math.round(player.posZ);
        List entities = player.worldObj.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)(posX - 0.5f), (double)(posY - 0.5f), (double)(posZ - 0.5f), (double)(posX + 0.5f), (double)(posY + 0.5f), (double)(posZ + 0.5f)).expand((double)range, (double)verticalRange, (double)range));
        List xpOrbs = player.worldObj.getEntitiesWithinAABB(EntityXPOrb.class, AxisAlignedBB.getBoundingBox((double)(posX - 0.5f), (double)(posY - 0.5f), (double)(posZ - 0.5f), (double)(posX + 0.5f), (double)(posY + 0.5f), (double)(posZ + 0.5f)).expand((double)range, (double)verticalRange, (double)range));
        for (EntityItem entity : entities) {
            if (entity == null || world.isRemote) continue;
            entity.onCollideWithPlayer(player);
        }
        for (EntityXPOrb xpOrb : xpOrbs) {
            if (xpOrb == null || world.isRemote) continue;
            xpOrb.onCollideWithPlayer(player);
        }
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 25;
    }
}

