/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil;

import WayofTime.alchemicalWizardry.AlchemicalWizardry;
import WayofTime.alchemicalWizardry.api.items.interfaces.ArmourUpgrade;
import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.EnergyItems;
import WayofTime.alchemicalWizardry.common.spell.complex.effect.SpellHelper;
import WayofTime.alchemicalWizardry.common.tileEntity.TESpectralContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SigilOfSupression
extends EnergyItems
implements ArmourUpgrade,
ISigil {
    @SideOnly(value=Side.CLIENT)
    private IIcon activeIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon passiveIcon;
    private int radius = 5;
    private int refresh = 100;

    public SigilOfSupression() {
        this.maxStackSize = 1;
        this.setEnergyUsed(AlchemicalWizardry.sigilSuppressionCost);
        this.setCreativeTab(AlchemicalWizardry.tabBloodMagic);
    }

    public void addInformation(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        par3List.add(StatCollector.translateToLocal((String)"tooltip.sigilofsupression.desc"));
        if (par1ItemStack.getTagCompound() != null) {
            if (par1ItemStack.getTagCompound().getBoolean("isActive")) {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.activated"));
            } else {
                par3List.add(StatCollector.translateToLocal((String)"tooltip.sigil.state.deactivated"));
            }
            par3List.add(StatCollector.translateToLocal((String)"tooltip.owner.currentowner") + " " + par1ItemStack.getTagCompound().getString("ownerName"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister iconRegister) {
        this.itemIcon = iconRegister.registerIcon("AlchemicalWizardry:SigilOfSupression_deactivated");
        this.activeIcon = iconRegister.registerIcon("AlchemicalWizardry:SigilOfSupression_activated");
        this.passiveIcon = iconRegister.registerIcon("AlchemicalWizardry:SigilOfSupression_deactivated");
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        NBTTagCompound tag;
        if (stack.getTagCompound() == null) {
            stack.setTagCompound(new NBTTagCompound());
        }
        if ((tag = stack.getTagCompound()).getBoolean("isActive")) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamage(int par1) {
        if (par1 == 1) {
            return this.activeIcon;
        }
        return this.passiveIcon;
    }

    public ItemStack onItemRightClick(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        NBTTagCompound tag;
        int tickDelay = 200;
        if (!EnergyItems.checkAndSetItemOwner(par1ItemStack, par3EntityPlayer) || SpellHelper.isFakePlayer(par2World, par3EntityPlayer)) {
            return par1ItemStack;
        }
        if (par3EntityPlayer.isSneaking()) {
            return par1ItemStack;
        }
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        tag.setBoolean("isActive", !(tag = par1ItemStack.getTagCompound()).getBoolean("isActive"));
        if (tag.getBoolean("isActive")) {
            par1ItemStack.setItemDamage(1);
            tag.setInteger("worldTimeDelay", (int)(par2World.getWorldTime() - 1L) % tickDelay);
            if (!par3EntityPlayer.capabilities.isCreativeMode && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
                tag.setBoolean("isActive", false);
            }
        } else {
            par1ItemStack.setItemDamage(par1ItemStack.getMaxDamage());
        }
        return par1ItemStack;
    }

    public void onUpdate(ItemStack par1ItemStack, World par2World, Entity par3Entity, int par4, boolean par5) {
        if (!(par3Entity instanceof EntityPlayer)) {
            return;
        }
        if (SpellHelper.isFakePlayer(par2World, (EntityPlayer)par3Entity)) {
            return;
        }
        EntityPlayer par3EntityPlayer = (EntityPlayer)par3Entity;
        if (par1ItemStack.getTagCompound() == null) {
            par1ItemStack.setTagCompound(new NBTTagCompound());
        }
        if (par1ItemStack.getTagCompound().getBoolean("isActive") && !par2World.isRemote) {
            Vec3 blockVec = SpellHelper.getEntityBlockVector((Entity)par3EntityPlayer);
            int x = (int)blockVec.xCoord;
            int y = (int)blockVec.yCoord;
            int z = (int)blockVec.zCoord;
            for (int i = -this.radius; i <= this.radius; ++i) {
                for (int j = -this.radius; j <= this.radius; ++j) {
                    for (int k = -this.radius; k <= this.radius; ++k) {
                        if ((float)(i * i + j * j + k * k) >= ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f)) continue;
                        Block block = par2World.getBlock(x + i, y + j, z + k);
                        if (SpellHelper.isBlockFluid(block)) {
                            if (par2World.getTileEntity(x + i, y + j, z + k) != null) {
                                par2World.setBlockToAir(x + i, y + j, z + k);
                            }
                            TESpectralContainer.createSpectralBlockAtLocation(par2World, x + i, y + j, z + k, this.refresh);
                            continue;
                        }
                        TileEntity tile = par2World.getTileEntity(x + i, y + j, z + k);
                        if (!(tile instanceof TESpectralContainer)) continue;
                        ((TESpectralContainer)tile).resetDuration(this.refresh);
                    }
                }
            }
        }
        if (par2World.getWorldTime() % 200L == (long)par1ItemStack.getTagCompound().getInteger("worldTimeDelay") && par1ItemStack.getTagCompound().getBoolean("isActive") && !par3EntityPlayer.capabilities.isCreativeMode && !EnergyItems.syphonBatteries(par1ItemStack, par3EntityPlayer, this.getEnergyUsed())) {
            par1ItemStack.getTagCompound().setBoolean("isActive", false);
        }
    }

    @Override
    public void onArmourUpdate(World world, EntityPlayer player, ItemStack thisItemStack) {
        Vec3 blockVec = SpellHelper.getEntityBlockVector((Entity)player);
        int x = (int)blockVec.xCoord;
        int y = (int)blockVec.yCoord;
        int z = (int)blockVec.zCoord;
        for (int i = -this.radius; i <= this.radius; ++i) {
            for (int j = -this.radius; j <= this.radius; ++j) {
                for (int k = -this.radius; k <= this.radius; ++k) {
                    if ((float)(i * i + j * j + k * k) >= ((float)this.radius + 0.5f) * ((float)this.radius + 0.5f)) continue;
                    Block block = world.getBlock(x + i, y + j, z + k);
                    if (SpellHelper.isBlockFluid(block)) {
                        if (world.getTileEntity(x + i, y + j, z + k) != null) {
                            world.setBlockToAir(x + i, y + j, z + k);
                        }
                        TESpectralContainer.createSpectralBlockAtLocation(world, x + i, y + j, z + k, this.refresh);
                        continue;
                    }
                    TileEntity tile = world.getTileEntity(x + i, y + j, z + k);
                    if (!(tile instanceof TESpectralContainer)) continue;
                    ((TESpectralContainer)tile).resetDuration(this.refresh);
                }
            }
        }
    }

    @Override
    public boolean isUpgrade() {
        return true;
    }

    @Override
    public int getEnergyForTenSeconds() {
        return 200;
    }
}

