/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.items.sigil.holding;

import WayofTime.alchemicalWizardry.api.items.interfaces.ISigil;
import WayofTime.alchemicalWizardry.common.items.sigil.holding.InventoryHolding;
import WayofTime.alchemicalWizardry.common.items.sigil.holding.SigilOfHolding;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ContainerHolding
extends Container {
    protected final int PLAYER_INVENTORY_ROWS = 3;
    protected final int PLAYER_INVENTORY_COLUMNS = 9;
    private int inventoryColumns = 5;
    private final EntityPlayer player;
    public final InventoryHolding inventoryHolding;

    public ContainerHolding(EntityPlayer player, InventoryHolding inventoryHolding) {
        this.player = player;
        this.inventoryHolding = inventoryHolding;
        int currentSlotHeldIn = player.inventory.currentItem;
        for (int columnIndex = 0; columnIndex < this.inventoryColumns; ++columnIndex) {
            this.addSlotToContainer(new SlotHolding(this, inventoryHolding, player, columnIndex, 8 + columnIndex * 36, 15));
        }
        for (int rowIndex = 0; rowIndex < 3; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < 9; ++columnIndex) {
                this.addSlotToContainer(new Slot((IInventory)player.inventory, columnIndex + rowIndex * 9 + 9, 8 + columnIndex * 18, 39 + rowIndex * 18));
            }
        }
        for (int actionBarIndex = 0; actionBarIndex < 9; ++actionBarIndex) {
            if (actionBarIndex == currentSlotHeldIn) {
                this.addSlotToContainer(new SlotDisabled((IInventory)player.inventory, actionBarIndex, 8 + actionBarIndex * 18, 97));
                continue;
            }
            this.addSlotToContainer(new Slot((IInventory)player.inventory, actionBarIndex, 8 + actionBarIndex * 18, 97));
        }
    }

    public boolean canInteractWith(EntityPlayer entityPlayer) {
        return true;
    }

    public void onContainerClosed(EntityPlayer entityPlayer) {
        super.onContainerClosed(entityPlayer);
        if (!entityPlayer.worldObj.isRemote) {
            this.saveInventory(entityPlayer);
        }
    }

    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (!this.player.worldObj.isRemote) {
            this.saveInventory(this.player);
        }
    }

    public ItemStack transferStackInSlot(EntityPlayer entityPlayer, int slotIndex) {
        ItemStack stack = null;
        Slot slotObject = (Slot)this.inventorySlots.get(slotIndex);
        int slots = this.inventorySlots.size();
        if (slotObject != null && slotObject.getHasStack()) {
            ItemStack stackInSlot = slotObject.getStack();
            stack = stackInSlot.copy();
            if (stack.getItem() instanceof ISigil ? (slotIndex < this.inventoryColumns ? !this.mergeItemStack(stackInSlot, this.inventoryColumns, slots, false) : !this.mergeItemStack(stackInSlot, 0, this.inventoryColumns, false)) : stack.getItem() instanceof SigilOfHolding && (slotIndex < this.inventoryColumns + 27 ? !this.mergeItemStack(stackInSlot, this.inventoryColumns + 27, this.inventorySlots.size(), false) : !this.mergeItemStack(stackInSlot, this.inventoryColumns, this.inventoryColumns + 27, false))) {
                return null;
            }
            if (stackInSlot.stackSize == 0) {
                slotObject.putStack(null);
            } else {
                slotObject.onSlotChanged();
            }
            if (stackInSlot.stackSize == stack.stackSize) {
                return null;
            }
            slotObject.onPickupFromSlot(this.player, stackInSlot);
        }
        return stack;
    }

    public void saveInventory(EntityPlayer entityPlayer) {
        this.inventoryHolding.onGuiSaved(entityPlayer);
    }

    private class SlotDisabled
    extends Slot {
        public SlotDisabled(IInventory inventory, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
        }

        public boolean isItemValid(ItemStack itemStack) {
            return false;
        }

        public boolean canTakeStack(EntityPlayer player) {
            return false;
        }
    }

    private class SlotHolding
    extends Slot {
        private final EntityPlayer player;
        private ContainerHolding containerHolding;

        public SlotHolding(ContainerHolding containerHolding2, IInventory inventory, EntityPlayer player, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.player = player;
            this.containerHolding = containerHolding2;
        }

        public void onSlotChanged() {
            super.onSlotChanged();
            if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                this.containerHolding.saveInventory(this.player);
            }
        }

        public boolean isItemValid(ItemStack itemStack) {
            return itemStack.getItem() instanceof ISigil;
        }
    }
}

