/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.omega;

import WayofTime.alchemicalWizardry.api.alchemy.energy.ReagentRegistry;
import WayofTime.alchemicalWizardry.common.items.armour.OmegaArmour;
import WayofTime.alchemicalWizardry.common.omega.OmegaParadigm;
import WayofTime.alchemicalWizardry.common.omega.ReagentRegenConfiguration;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class OmegaParadigmWind
extends OmegaParadigm {
    public OmegaParadigmWind(OmegaArmour helmet, OmegaArmour chestPiece, OmegaArmour leggings, OmegaArmour boots) {
        super(ReagentRegistry.aetherReagent, helmet, chestPiece, leggings, boots, new ReagentRegenConfiguration(50, 1, 10.0f));
    }

    @Override
    public float getCostPerTickOfUse(EntityPlayer player) {
        if (player.isAirBorne) {
            return 0.5f;
        }
        return 1.0f;
    }

    @Override
    public void onUpdate(World world, EntityPlayer player, ItemStack stack) {
        if (world.getWorldTime() % 100L == 0L && !world.isRemote && player.posY > 128.0 && player.getHealth() < player.getMaxHealth()) {
            player.addPotionEffect(new PotionEffect(Potion.regeneration.id, 200, player.posY > 192.0 ? 1 : 0, true));
        }
        player.fallDistance = 0.0f;
    }

    @Override
    public boolean getBlockEffectWhileInside(Entity entity, int x, int y, int z) {
        return true;
    }

    @Override
    public void onOmegaKeyPressed(EntityPlayer player, ItemStack stack) {
    }
}

