/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.alchemicalWizardry.common.renderer;

import WayofTime.alchemicalWizardry.api.ColourAndCoords;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BeamRenderer {
    private static final ResourceLocation field_110629_a = new ResourceLocation("textures/entity/beacon_beam.png");
    public int xInit;
    public int yInit;
    public int zInit;
    public int xFinal;
    public int yFinal;
    public int zFinal;
    public int colourRed;
    public int colourGreen;
    public int colourBlue;
    public int colourIntensity;
    public double size;

    public void setInitialPosition(int x, int y, int z) {
        this.xInit = x;
        this.yInit = y;
        this.zInit = z;
    }

    public void setColourAndFinalPosition(ColourAndCoords col) {
        this.colourRed = col.colourRed;
        this.colourGreen = col.colourGreen;
        this.colourBlue = col.colourBlue;
        this.colourIntensity = col.colourIntensity;
        this.xFinal = col.xCoord;
        this.yFinal = col.yCoord;
        this.zFinal = col.zCoord;
    }

    public void setSize(double size) {
        this.size = size;
    }

    protected static void bindTexture(ResourceLocation p_147499_1_) {
        TextureManager texturemanager = TileEntityRendererDispatcher.instance.field_147553_e;
        if (texturemanager != null) {
            texturemanager.bindTexture(p_147499_1_);
        }
    }

    public void render(double d0, double d1, double d2) {
        int xDiff = this.xFinal - this.xInit;
        int yDiff = this.yFinal - this.yInit;
        int zDiff = this.zFinal - this.zInit;
        float planarAngle = (float)(Math.atan2(-zDiff, xDiff) * 180.0 / Math.PI);
        float verticalAngle = (float)(Math.atan2(yDiff, Math.sqrt(xDiff * xDiff + zDiff + zDiff)) * 180.0 / Math.PI);
        float distance = (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
        GL11.glPushMatrix();
        float f1 = 1.0f;
        Tessellator tessellator = Tessellator.instance;
        BeamRenderer.bindTexture(field_110629_a);
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2896);
        GL11.glDisable((int)2884);
        float f2 = 0.0f;
        float f3 = -f2 * 0.2f - (float)MathHelper.floor_float((float)(-f2 * 0.1f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDepthMask((boolean)false);
        tessellator.startDrawingQuads();
        tessellator.setColorRGBA(this.colourRed, this.colourGreen, this.colourBlue, this.colourIntensity);
        double inside = -(this.size / 2.0);
        double outside = 1.0 - (0.5 - this.size / 2.0) - 0.5;
        double d18 = inside;
        double d19 = inside;
        double d20 = outside;
        double d21 = inside;
        double d22 = inside;
        double d23 = outside;
        double d24 = outside;
        double d25 = outside;
        double d26 = distance * f1;
        double d27 = 0.0;
        double d28 = 1.0;
        double d29 = -1.0f + f3;
        double d30 = (double)(distance * f1) + d29;
        GL11.glTranslated((double)(d0 + 0.5), (double)(d1 + 0.5), (double)(d2 + 0.5));
        GL11.glRotatef((float)planarAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)verticalAngle, (float)0.0f, (float)0.0f, (float)1.0f);
        double offset = 0.0;
        tessellator.setBrightness(240);
        float s = 0.0625f;
        tessellator.addVertexWithUV(d26, d18, d19, d28, d30);
        tessellator.addVertexWithUV(offset, d18, d19, d28, d29);
        tessellator.addVertexWithUV(offset, d20, d21, d27, d29);
        tessellator.addVertexWithUV(d26, d20, d21, d27, d30);
        tessellator.addVertexWithUV(d26, d24, d25, d28, d30);
        tessellator.addVertexWithUV(offset, d24, d25, d28, d29);
        tessellator.addVertexWithUV(offset, d22, d23, d27, d29);
        tessellator.addVertexWithUV(d26, d22, d23, d27, d30);
        tessellator.addVertexWithUV(d26, d20, d21, d28, d30);
        tessellator.addVertexWithUV(offset, d20, d21, d28, d29);
        tessellator.addVertexWithUV(offset, d24, d25, d27, d29);
        tessellator.addVertexWithUV(d26, d24, d25, d27, d30);
        tessellator.addVertexWithUV(d26, d22, d23, d28, d30);
        tessellator.addVertexWithUV(offset, d22, d23, d28, d29);
        tessellator.addVertexWithUV(offset, d18, d19, d27, d29);
        tessellator.addVertexWithUV(d26, d18, d19, d27, d30);
        tessellator.draw();
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)3553);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glPopMatrix();
    }
}

